<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Unit Details</h1>
    <div class="d-flex gap-2">
        <a href="<?= base_url('/units') ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i> Back to Units
        </a>
        <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
        <a href="<?= base_url('/units/edit/' . $unit['id']) ?>" class="btn btn-primary">
            <i class="fas fa-edit me-2"></i> Edit Unit
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- Success/Error Messages -->
<div id="message-container">
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>Error!</strong> <?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
</div>

<!-- Unit Details -->
<div class="card border-0 shadow-sm">
    <div class="card-header bg-white border-bottom">
        <h2 class="h4 mb-0"><?= esc($unit['unit_name']) ?></h2>
    </div>
    
    <div class="card-body">
        <div class="row g-4">
            <!-- Company Information -->
            <div class="col-md-6">
                <div class="card border">
                    <div class="card-body">
                        <h3 class="h5 mb-4">Company Information</h3>
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Company Name</label>
                            <p class="mb-0"><?= esc($company['company_name']) ?></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Unit Information -->
            <div class="col-md-6">
                <div class="card border">
                    <div class="card-body">
                        <h3 class="h5 mb-4">Unit Information</h3>
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Unit Name</label>
                            <p class="mb-0"><?= esc($unit['unit_name']) ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Unit Location</label>
                            <p class="mb-0"><?= nl2br(esc($unit['unit_location'])) ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Status</label>
                            <p class="mb-0">
                                <?php if ($unit['status'] === 'Active'): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Inactive</span>
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Manager Information -->
            <div class="col-md-6">
                <div class="card border">
                    <div class="card-body">
                        <h3 class="h5 mb-4">Manager Information</h3>
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Manager Name</label>
                            <p class="mb-0"><?= $unit['unit_manager_name'] ?? '-' ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Manager Number</label>
                            <p class="mb-0"><?= $unit['unit_manager_number'] ?? '-' ?></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- HR Information -->
            <div class="col-md-6">
                <div class="card border">
                    <div class="card-body">
                        <h3 class="h5 mb-4">HR Information</h3>
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">HR Name</label>
                            <p class="mb-0"><?= $unit['unit_hr_name'] ?? '-' ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">HR Number</label>
                            <p class="mb-0"><?= $unit['unit_hr_number'] ?? '-' ?></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Worker Information -->
            <div class="col-12">
                <div class="card border">
                    <div class="card-body">
                        <h3 class="h5 mb-4">Worker Information</h3>
                        <div class="row g-3">
                            <div class="col-md-4">
                                <div class="card bg-primary bg-opacity-10 border-0">
                                    <div class="card-body text-center">
                                        <div class="h2 fw-bold text-primary"><?= $unit['total_workers'] ?></div>
                                        <div class="text-primary">Total Workers</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="card bg-success bg-opacity-10 border-0">
                                    <div class="card-body text-center">
                                        <div class="h2 fw-bold text-success"><?= $unit['contractual_workers'] ?></div>
                                        <div class="text-success">Contractual Workers</div>
                                    </div>
                                </div>
                            </div>
                            
                            <div class="col-md-4">
                                <div class="card bg-info bg-opacity-10 border-0">
                                    <div class="card-body text-center">
                                        <div class="h2 fw-bold text-info"><?= $unit['total_workers'] - $unit['contractual_workers'] ?></div>
                                        <div class="text-info">Regular Workers</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Timestamps -->
        <div class="row g-3 mt-4 pt-4 border-top">
            <div class="col-md-6">
                <label class="form-label fw-medium text-muted">Created At</label>
                <p class="mb-0"><?= $unit['created_at'] ?></p>
            </div>
            
            <div class="col-md-6">
                <label class="form-label fw-medium text-muted">Last Updated</label>
                <p class="mb-0"><?= $unit['updated_at'] ?></p>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>