<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Unit</h1>
    <a href="<?= base_url('/units') ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-2"></i> Back to Units
    </a>
</div>

<!-- Success/Error Messages -->
<div id="message-container">
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>Error!</strong> <?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
</div>

<!-- Unit Edit Form -->
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <form id="unit-form" action="<?= base_url('/units/update/' . $unit['id']) ?>" method="POST">
            <?= csrf_field() ?>
            
            <div class="row g-3">
                <!-- Company -->
                <div class="col-md-6">
                    <label for="company_id" class="form-label">Company <span class="text-danger">*</span></label>
                    <select name="company_id" id="company_id" required class="form-select">
                        <option value="">Select a Company</option>
                        <?php foreach ($companies as $company): ?>
                            <option value="<?= $company['id'] ?>" <?= (old('company_id', $unit['company_id']) == $company['id']) ? 'selected' : '' ?>><?= $company['company_name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('company_id')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('company_id') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Unit Name -->
                <div class="col-md-6">
                    <label for="unit_name" class="form-label">Unit Name <span class="text-danger">*</span></label>
                    <input type="text" name="unit_name" id="unit_name" value="<?= old('unit_name', $unit['unit_name']) ?>" required class="form-control">
                    <?php if (isset($validation) && $validation->hasError('unit_name')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('unit_name') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Unit Location -->
                <div class="col-12">
                    <label for="unit_location" class="form-label">Unit Location <span class="text-danger">*</span></label>
                    <textarea name="unit_location" id="unit_location" rows="3" required class="form-control"><?= old('unit_location', $unit['unit_location']) ?></textarea>
                    <?php if (isset($validation) && $validation->hasError('unit_location')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('unit_location') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Unit Manager Name -->
                <div class="col-md-6">
                    <label for="unit_manager_name" class="form-label">Unit Manager Name</label>
                    <input type="text" name="unit_manager_name" id="unit_manager_name" value="<?= old('unit_manager_name', $unit['unit_manager_name']) ?>" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('unit_manager_name')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('unit_manager_name') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Unit Manager Number -->
                <div class="col-md-6">
                    <label for="unit_manager_number" class="form-label">Unit Manager Number</label>
                    <input type="text" name="unit_manager_number" id="unit_manager_number" value="<?= old('unit_manager_number', $unit['unit_manager_number']) ?>" placeholder="+91XXXXXXXXXX" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('unit_manager_number')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('unit_manager_number') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Unit HR Name -->
                <div class="col-md-6">
                    <label for="unit_hr_name" class="form-label">Unit HR Name</label>
                    <input type="text" name="unit_hr_name" id="unit_hr_name" value="<?= old('unit_hr_name', $unit['unit_hr_name']) ?>" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('unit_hr_name')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('unit_hr_name') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Unit HR Number -->
                <div class="col-md-6">
                    <label for="unit_hr_number" class="form-label">Unit HR Number</label>
                    <input type="text" name="unit_hr_number" id="unit_hr_number" value="<?= old('unit_hr_number', $unit['unit_hr_number']) ?>" placeholder="+91XXXXXXXXXX" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('unit_hr_number')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('unit_hr_number') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Total Workers -->
                <div class="col-md-6">
                    <label for="total_workers" class="form-label">Total Workers <span class="text-danger">*</span></label>
                    <input type="number" name="total_workers" id="total_workers" value="<?= old('total_workers', $unit['total_workers']) ?>" min="0" required class="form-control">
                    <?php if (isset($validation) && $validation->hasError('total_workers')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('total_workers') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Contractual Workers -->
                <div class="col-md-6">
                    <label for="contractual_workers" class="form-label">Contractual Workers <span class="text-danger">*</span></label>
                    <input type="number" name="contractual_workers" id="contractual_workers" value="<?= old('contractual_workers', $unit['contractual_workers']) ?>" min="0" required class="form-control">
                    <?php if (isset($validation) && $validation->hasError('contractual_workers')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('contractual_workers') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Status -->
                <div class="col-md-6">
                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                    <select name="status" id="status" required class="form-select">
                        <option value="Active" <?= (old('status', $unit['status']) === 'Active') ? 'selected' : '' ?>>Active</option>
                        <option value="Inactive" <?= (old('status', $unit['status']) === 'Inactive') ? 'selected' : '' ?>>Inactive</option>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('status')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('status') ?></div>
                    <?php endif; ?>
                </div>
                
                <div class="col-12">
                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?= base_url('/units') ?>" class="btn btn-secondary me-md-2">Cancel</a>
                        <button type="submit" id="submit-btn" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Update Unit
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    // Handle form submission with loading indicator
    document.getElementById('unit-form').addEventListener('submit', function() {
        const submitBtn = document.getElementById('submit-btn');
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Updating...';
        submitBtn.disabled = true;
    });
</script>
<?= $this->endSection() ?>