<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Settings</h1>
</div>

<!-- Success/Error Messages -->
<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Success!</strong> <?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Error!</strong> <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<!-- Settings Tabs -->
<ul class="nav nav-tabs mb-4" id="settingsTabs" role="tablist">
    <li class="nav-item" role="presentation">
        <button class="nav-link active" id="general-tab" data-bs-toggle="tab" data-bs-target="#general" type="button" role="tab" aria-controls="general" aria-selected="true">
            <i class="fas fa-cog me-2"></i>General
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="notifications-tab" data-bs-toggle="tab" data-bs-target="#notifications" type="button" role="tab" aria-controls="notifications" aria-selected="false">
            <i class="fas fa-bell me-2"></i>Notifications
        </button>
    </li>
    <li class="nav-item" role="presentation">
        <button class="nav-link" id="security-tab" data-bs-toggle="tab" data-bs-target="#security" type="button" role="tab" aria-controls="security" aria-selected="false">
            <i class="fas fa-shield-alt me-2"></i>Security
        </button>
    </li>
</ul>

<!-- Tab Content -->
<div class="tab-content" id="settingsTabContent">
    <!-- General Settings Tab -->
    <div class="tab-pane fade show active" id="general" role="tabpanel" aria-labelledby="general-tab">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h2 class="h4 mb-4">General Settings</h2>
                
                <form action="<?= base_url('/settings/update-general') ?>" method="POST">
                    <?= csrf_field() ?>
                    
                    <div class="row g-3">
                        <!-- Application Name -->
                        <div class="col-md-6">
                            <label for="app_name" class="form-label">Application Name</label>
                            <input type="text" name="app_name" id="app_name" value="<?= isset($settings['app_name']) ? esc($settings['app_name']) : 'Labourdnhdd - CMS' ?>" class="form-control">
                        </div>
                        
                        <!-- Theme -->
                        <div class="col-md-6">
                            <label for="app_theme" class="form-label">Theme</label>
                            <select name="app_theme" id="app_theme" class="form-select">
                                <option value="light" <?= (isset($settings['app_theme']) && $settings['app_theme'] === 'light') ? 'selected' : '' ?>>Light</option>
                                <option value="dark" <?= (isset($settings['app_theme']) && $settings['app_theme'] === 'dark') ? 'selected' : '' ?>>Dark</option>
                                <option value="auto" <?= (!isset($settings['app_theme']) || $settings['app_theme'] === 'auto') ? 'selected' : '' ?>>Auto</option>
                            </select>
                        </div>
                        
                        <!-- Timezone -->
                        <div class="col-md-6">
                            <label for="timezone" class="form-label">Timezone</label>
                            <select name="timezone" id="timezone" class="form-select">
                                <option value="UTC" <?= (isset($settings['timezone']) && $settings['timezone'] === 'UTC') ? 'selected' : '' ?>>UTC</option>
                                <option value="Asia/Kolkata" <?= (!isset($settings['timezone']) || $settings['timezone'] === 'Asia/Kolkata') ? 'selected' : '' ?>>Asia/Kolkata (IST)</option>
                                <option value="America/New_York" <?= (isset($settings['timezone']) && $settings['timezone'] === 'America/New_York') ? 'selected' : '' ?>>America/New_York (EST)</option>
                                <option value="Europe/London" <?= (isset($settings['timezone']) && $settings['timezone'] === 'Europe/London') ? 'selected' : '' ?>>Europe/London (GMT)</option>
                            </select>
                        </div>
                    </div>
                    
                    <!-- Submit Button -->
                    <div class="d-flex justify-content-end mt-4">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Save Changes
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Notifications Settings Tab -->
    <div class="tab-pane fade" id="notifications" role="tabpanel" aria-labelledby="notifications-tab">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h2 class="h4 mb-4">Notification Settings</h2>
                
                <form action="<?= base_url('/settings/update-notifications') ?>" method="POST">
                    <?= csrf_field() ?>
                    
                    <div class="mb-3">
                        <!-- Email Notifications -->
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" name="email_notifications" id="email_notifications" <?= (isset($settings['email_notifications']) && $settings['email_notifications'] === '1') ? 'checked' : '' ?>>
                            <label class="form-check-label" for="email_notifications">Email Notifications</label>
                            <div class="form-text">Receive email notifications for important events</div>
                        </div>
                        
                        <!-- SMS Notifications -->
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" name="sms_notifications" id="sms_notifications" <?= (isset($settings['sms_notifications']) && $settings['sms_notifications'] === '1') ? 'checked' : '' ?>>
                            <label class="form-check-label" for="sms_notifications">SMS Notifications</label>
                            <div class="form-text">Receive SMS notifications for urgent alerts</div>
                        </div>
                        
                        <!-- Push Notifications -->
                        <div class="form-check form-switch">
                            <input class="form-check-input" type="checkbox" name="push_notifications" id="push_notifications" <?= (isset($settings['push_notifications']) && $settings['push_notifications'] === '1') ? 'checked' : '' ?>>
                            <label class="form-check-label" for="push_notifications">Push Notifications</label>
                            <div class="form-text">Receive push notifications on your devices</div>
                        </div>
                    </div>
                    
                    <!-- Submit Button -->
                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Save Changes
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Security Settings Tab -->
    <div class="tab-pane fade" id="security" role="tabpanel" aria-labelledby="security-tab">
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <h2 class="h4 mb-4">Security Settings</h2>
                
                <form action="<?= base_url('/settings/update-security') ?>" method="POST">
                    <?= csrf_field() ?>
                    
                    <div class="mb-3">
                        <!-- Two-Factor Authentication -->
                        <div class="form-check form-switch mb-3">
                            <input class="form-check-input" type="checkbox" name="two_factor_auth" id="two_factor_auth" <?= (isset($settings['two_factor_auth']) && $settings['two_factor_auth'] === '1') ? 'checked' : '' ?>>
                            <label class="form-check-label" for="two_factor_auth">Two-Factor Authentication</label>
                            <div class="form-text">Require two-factor authentication for all users</div>
                        </div>
                        
                        <!-- Password Expiry -->
                        <div>
                            <label for="password_expiry" class="form-label">Password Expiry (Days)</label>
                            <input type="number" name="password_expiry" id="password_expiry" value="<?= isset($settings['password_expiry']) ? esc($settings['password_expiry']) : '90' ?>" min="1" max="365" class="form-control w-25">
                            <div class="form-text">Number of days after which passwords must be changed</div>
                        </div>
                    </div>
                    
                    <!-- Submit Button -->
                    <div class="d-flex justify-content-end">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Save Changes
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>