<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Security Logs</h1>
</div>

<!-- Filter Form -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <form action="<?= base_url('/security-logs') ?>" method="GET" class="row g-3">
            <div class="col-md-3">
                <label for="severity" class="form-label">Severity</label>
                <select name="severity" id="severity" class="form-select">
                    <option value="">All Severities</option>
                    <option value="low" <?= (isset($severity) && $severity === 'low') ? 'selected' : '' ?>>Low</option>
                    <option value="medium" <?= (isset($severity) && $severity === 'medium') ? 'selected' : '' ?>>Medium</option>
                    <option value="high" <?= (isset($severity) && $severity === 'high') ? 'selected' : '' ?>>High</option>
                    <option value="critical" <?= (isset($severity) && $severity === 'critical') ? 'selected' : '' ?>>Critical</option>
                </select>
            </div>
            
            <div class="col-md-3">
                <label for="event_type" class="form-label">Event Type</label>
                <select name="event_type" id="event_type" class="form-select">
                    <option value="">All Event Types</option>
                    <?php foreach ($event_types as $type): ?>
                        <option value="<?= esc($type) ?>" <?= (isset($event_type) && $event_type === $type) ? 'selected' : '' ?>><?= esc(ucfirst(str_replace('_', ' ', $type))) ?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            
            <div class="col-md-4">
                <label for="search" class="form-label">Search</label>
                <input type="text" name="search" id="search" value="<?= isset($search) ? esc($search) : '' ?>" placeholder="Search logs..." class="form-control">
            </div>
            
            <div class="col-md-2 d-flex align-items-end">
                <button type="submit" class="btn btn-primary w-100">
                    <i class="fas fa-filter me-2"></i> Filter
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Security Logs Table -->
<div class="card border-0 shadow-sm">
    <div class="table-responsive">
        <table class="table table-hover align-middle mb-0">
            <thead class="table-light">
                <tr>
                    <th scope="col">Timestamp</th>
                    <th scope="col">User</th>
                    <th scope="col">IP Address</th>
                    <th scope="col">Event Type</th>
                    <th scope="col">Description</th>
                    <th scope="col">Severity</th>
                </tr>
            </thead>
            <tbody>
                <?php if (!empty($logs)): ?>
                    <?php foreach ($logs as $log): ?>
                        <tr>
                            <td><?= esc($log['created_at']) ?></td>
                            <td><?= esc($log['user_id'] ?? 'N/A') ?></td>
                            <td><?= esc($log['ip_address'] ?? 'N/A') ?></td>
                            <td><?= esc(ucfirst(str_replace('_', ' ', $log['event_type']))) ?></td>
                            <td><?= esc($log['description']) ?></td>
                            <td>
                                <?php
                                $severityClass = '';
                                switch ($log['severity']) {
                                    case 'low':
                                        $severityClass = 'bg-success';
                                        break;
                                    case 'medium':
                                        $severityClass = 'bg-warning';
                                        break;
                                    case 'high':
                                        $severityClass = 'bg-orange';
                                        break;
                                    case 'critical':
                                        $severityClass = 'bg-danger';
                                        break;
                                }
                                ?>
                                <span class="badge <?= $severityClass ?>">
                                    <?= esc(ucfirst($log['severity'])) ?>
                                </span>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="6" class="text-center py-4 text-muted">
                            No security logs found.
                        </td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    <?php if (!empty($logs)): ?>
        <div class="card-footer border-0">
            <?= $pager->links('default', 'bootstrap') ?>
        </div>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>