<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Reset Password - Labourdnhdd - CMS</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-light: #5EC9F8;
            --primary-medium: #3A82D4;
            --primary-dark: #214D8C;
            --accent-saffron: #FF9933;
            --accent-green: #138808;
            --jtech-blue: linear-gradient(135deg, #5EC9F8 0%, #3A82D4 50%, #214D8C 100%);
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .reset-card {
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.1);
            overflow: hidden;
            border: none;
        }
        
        .brand-header {
            background: var(--jtech-blue);
            color: white;
            text-align: center;
            padding: 2rem 1rem;
        }
        
        .brand-logo {
            background-color: white;
            border-radius: 50%;
            width: 80px;
            height: 80px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
        }
        
        .brand-logo span {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-medium);
        }
        
        .brand-title {
            font-weight: 700;
            margin-bottom: 0.25rem;
        }
        
        .brand-subtitle {
            font-weight: 500;
            opacity: 0.9;
        }
        
        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
        }
        
        .btn-reset {
            background: var(--jtech-blue);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-reset:hover {
            background: #214D8C;
            transform: translateY(-2px);
            box-shadow: 0 0.25rem 0.5rem rgba(0,0,0,0.1);
        }
        
        .password-strength {
            height: 5px;
            background-color: #e2e8f0;
            border-radius: 3px;
            margin-top: 5px;
            overflow: hidden;
        }
        
        .strength-meter {
            height: 100%;
            width: 0;
            transition: width 0.3s ease, background-color 0.3s ease;
        }
        
        .footer-text {
            color: #6c757d;
            font-size: 0.875rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card reset-card">
                    <!-- Header with Logo -->
                    <div class="brand-header">
                        <div class="brand-logo">
                            <span>J</span>
                        </div>
                        <h1 class="h3 brand-title">Labourdnhdd - CMS</h1>
                        <p class="mb-0 brand-subtitle">Code Your Vision</p>
                    </div>
                    
                    <!-- Reset Password Form -->
                    <div class="card-body p-4">
                        <h2 class="text-center mb-1">Reset Password</h2>
                        <p class="text-center text-muted mb-4">Create a new password for your account</p>
                        
                        <?php if (session()->getFlashdata('error')): ?>
                            <div class="alert alert-danger">
                                <?= session()->getFlashdata('error') ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>
                        
                        <form action="<?= base_url('/forgot-password/update-password') ?>" method="post" id="resetPasswordForm">
                            <?= csrf_field() ?>
                            
                            <div class="mb-3">
                                <label for="password" class="form-label fw-medium">
                                    <i class="fas fa-lock me-2 text-primary"></i>New Password
                                </label>
                                <input 
                                    type="password" 
                                    id="password" 
                                    name="password" 
                                    class="form-control"
                                    placeholder="Enter new password"
                                    required
                                >
                                <div class="password-strength">
                                    <div class="strength-meter" id="strengthMeter"></div>
                                </div>
                                <div class="form-text">Password must be at least 8 characters with uppercase, lowercase, number, and special character</div>
                                <?php if (isset($validation) && $validation->hasError('password')): ?>
                                    <div class="text-danger small mt-1"><?= $validation->getError('password') ?></div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mb-4">
                                <label for="confirm_password" class="form-label fw-medium">
                                    <i class="fas fa-lock me-2 text-primary"></i>Confirm Password
                                </label>
                                <input 
                                    type="password" 
                                    id="confirm_password" 
                                    name="confirm_password" 
                                    class="form-control"
                                    placeholder="Confirm new password"
                                    required
                                >
                                <?php if (isset($validation) && $validation->hasError('confirm_password')): ?>
                                    <div class="text-danger small mt-1"><?= $validation->getError('confirm_password') ?></div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="d-grid mb-3">
                                <button 
                                    type="submit" 
                                    class="btn btn-reset" 
                                    id="resetPasswordButton"
                                >
                                    Reset Password
                                </button>
                            </div>
                        </form>
                        
                        <div class="text-center">
                            <a href="<?= base_url('/login') ?>" class="text-decoration-none text-primary">
                                <i class="fas fa-arrow-left me-1"></i> Back to Login
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-footer text-center">
                        <p class="mb-0 footer-text">&copy; <?= date('Y') ?> Labourdnhdd - CMS. All rights reserved.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Password strength indicator
        document.addEventListener('DOMContentLoaded', function() {
            const passwordInput = document.getElementById('password');
            const strengthMeter = document.getElementById('strengthMeter');
            
            if (passwordInput && strengthMeter) {
                passwordInput.addEventListener('input', function() {
                    const password = passwordInput.value;
                    let strength = 0;
                    
                    // Check password strength
                    if (password.length >= 8) strength += 25;
                    if (/[A-Z]/.test(password)) strength += 25;
                    if (/[a-z]/.test(password)) strength += 25;
                    if (/[0-9!@#$%^&*]/.test(password)) strength += 25;
                    
                    strengthMeter.style.width = strength + '%';
                    
                    // Set color based on strength
                    if (strength < 50) {
                        strengthMeter.style.backgroundColor = '#dc3545'; // red
                    } else if (strength < 75) {
                        strengthMeter.style.backgroundColor = '#ffc107'; // yellow
                    } else {
                        strengthMeter.style.backgroundColor = '#198754'; // green
                    }
                });
            }
        });
    </script>
</body>
</html>