<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Personnel Details</h1>
    <div class="d-flex gap-2">
        <a href="<?= base_url('/personnel') ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i> Back to Personnel
        </a>
        <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
        <a href="<?= base_url('/personnel/edit/' . $personnel['id']) ?>" class="btn btn-primary">
            <i class="fas fa-edit me-2"></i> Edit Personnel
        </a>
        <?php endif; ?>
    </div>
</div>

<!-- Success/Error Messages -->
<div id="message-container">
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>Error!</strong> <?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
</div>

<!-- Personnel Details -->
<div class="card border-0 shadow-sm">
    <div class="card-header bg-white border-bottom">
        <h2 class="h4 mb-0"><?= esc($personnel['name']) ?></h2>
        <p class="mb-0 text-muted"><?= $personnel['role'] ?></p>
    </div>
    
    <div class="card-body">
        <div class="row g-4">
            <!-- Basic Information -->
            <div class="col-md-6">
                <div class="card border">
                    <div class="card-body">
                        <h3 class="h5 mb-4">Basic Information</h3>
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Full Name</label>
                            <p class="mb-0"><?= esc($personnel['name']) ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Role</label>
                            <p class="mb-0"><?= $personnel['role'] ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Status</label>
                            <p class="mb-0">
                                <?php if ($personnel['status'] === 'Active'): ?>
                                    <span class="badge bg-success">Active</span>
                                <?php else: ?>
                                    <span class="badge bg-danger">Left</span>
                                <?php endif; ?>
                            </p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Contact Information -->
            <div class="col-md-6">
                <div class="card border">
                    <div class="card-body">
                        <h3 class="h5 mb-4">Contact Information</h3>
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Email</label>
                            <p class="mb-0"><?= $personnel['email'] ?? '-' ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Phone</label>
                            <p class="mb-0"><?= $personnel['phone'] ?? '-' ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Address</label>
                            <p class="mb-0"><?= $personnel['address'] ?? '-' ?></p>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- Company Information -->
            <?php if ($company || $unit): ?>
            <div class="col-md-6">
                <div class="card border">
                    <div class="card-body">
                        <h3 class="h5 mb-4">Company Information</h3>
                        <?php if ($company): ?>
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Company</label>
                            <p class="mb-0"><?= esc($company['company_name']) ?></p>
                        </div>
                        <?php endif; ?>
                        
                        <?php if ($unit): ?>
                        <div class="mb-3">
                            <label class="form-label fw-medium text-muted">Unit</label>
                            <p class="mb-0"><?= esc($unit['unit_name']) ?></p>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
        
        <!-- Timestamps -->
        <div class="row g-4 mt-4 pt-4 border-top">
            <div class="col-md-6">
                <label class="form-label fw-medium text-muted">Created At</label>
                <p class="mb-0"><?= $personnel['created_at'] ?></p>
            </div>
            
            <div class="col-md-6">
                <label class="form-label fw-medium text-muted">Last Updated</label>
                <p class="mb-0"><?= $personnel['updated_at'] ?></p>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>