<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">
        <?= isset($company) ? 'Add New Personnel for ' . esc($company['company_name']) : 'Add New Personnel' ?>
    </h1>
    <?php if (isset($company)): ?>
        <a href="<?= base_url('/companies/' . $company['id'] . '/personnel') ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i> Back to Personnel
        </a>
    <?php else: ?>
        <a href="<?= base_url('/personnel') ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i> Back to Personnel
        </a>
    <?php endif; ?>
</div>

<!-- Success/Error Messages -->
<div id="message-container">
    <?php if (session()->getFlashdata('success')): ?>
        <div class="alert alert-success alert-dismissible fade show" role="alert">
            <strong>Success!</strong> <?= session()->getFlashdata('success') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <strong>Error!</strong> <?= session()->getFlashdata('error') ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
        </div>
    <?php endif; ?>
</div>

<!-- Personnel Creation Form -->
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <form id="personnel-form" action="<?= base_url(isset($company) ? '/personnel/store' : '/personnel/store') ?>" method="POST">
            <?= csrf_field() ?>
            
            <?php if (isset($company)): ?>
                <!-- Hidden company ID field for company-specific creation -->
                <input type="hidden" name="company_id" value="<?= $company['id'] ?>">
            <?php endif; ?>
            
            <div class="row g-4">
                <!-- Name -->
                <div class="col-md-6">
                    <label for="name" class="form-label">Full Name <span class="text-danger">*</span></label>
                    <input type="text" name="name" id="name" value="<?= old('name') ?>" required class="form-control">
                    <?php if (isset($validation) && $validation->hasError('name')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('name') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Role -->
                <div class="col-md-6">
                    <label for="role" class="form-label">Role <span class="text-danger">*</span></label>
                    <select name="role" id="role" required class="form-select">
                        <option value="">Select a Role</option>
                        <option value="Manager" <?= (old('role') === 'Manager') ? 'selected' : '' ?>>Manager</option>
                        <option value="HR" <?= (old('role') === 'HR') ? 'selected' : '' ?>>HR</option>
                        <option value="Owner" <?= (old('role') === 'Owner') ? 'selected' : '' ?>>Owner</option>
                        <option value="Other" <?= (old('role', 'Other') === 'Other') ? 'selected' : '' ?>>Other</option>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('role')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('role') ?></div>
                    <?php endif; ?>
                </div>
                
                <?php if (!isset($company)): ?>
                <!-- Company (only show when not in company context) -->
                <div class="col-md-6">
                    <label for="company_id" class="form-label">Company</label>
                    <select name="company_id" id="company_id" class="form-select">
                        <option value="">Select a Company (Optional)</option>
                        <?php foreach ($companies as $companyItem): ?>
                            <option value="<?= $companyItem['id'] ?>" <?= (old('company_id') == $companyItem['id']) ? 'selected' : '' ?>><?= $companyItem['company_name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('company_id')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('company_id') ?></div>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
                
                <!-- Unit -->
                <div class="col-md-6">
                    <label for="unit_id" class="form-label">Unit</label>
                    <select name="unit_id" id="unit_id" class="form-select">
                        <option value="">Select a Unit (Optional)</option>
                        <?php foreach ($units as $unit): ?>
                            <option value="<?= $unit['id'] ?>" <?= (old('unit_id') == $unit['id']) ? 'selected' : '' ?>><?= $unit['unit_name'] ?></option>
                        <?php endforeach; ?>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('unit_id')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('unit_id') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Email -->
                <div class="col-md-6">
                    <label for="email" class="form-label">Email</label>
                    <input type="email" name="email" id="email" value="<?= old('email') ?>" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('email')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('email') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Phone -->
                <div class="col-md-6">
                    <label for="phone" class="form-label">Phone</label>
                    <input type="text" name="phone" id="phone" value="<?= old('phone') ?>" placeholder="+91XXXXXXXXXX" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('phone')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('phone') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Address -->
                <div class="col-12">
                    <label for="address" class="form-label">Address</label>
                    <textarea name="address" id="address" rows="3" class="form-control"><?= old('address') ?></textarea>
                    <?php if (isset($validation) && $validation->hasError('address')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('address') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Status -->
                <div class="col-md-6">
                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                    <select name="status" id="status" required class="form-select">
                        <option value="Active" <?= (old('status', 'Active') === 'Active') ? 'selected' : '' ?>>Active</option>
                        <option value="Left" <?= (old('status') === 'Left') ? 'selected' : '' ?>>Left</option>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('status')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('status') ?></div>
                    <?php endif; ?>
                </div>
                
                <div class="col-12">
                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <button type="reset" class="btn btn-secondary me-md-2">Reset</button>
                        <button type="submit" id="submit-btn" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i> Save Personnel
                        </button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<script>
    // Handle form submission with loading indicator
    document.getElementById('personnel-form').addEventListener('submit', function() {
        const submitBtn = document.getElementById('submit-btn');
        submitBtn.innerHTML = '<i class="fas fa-spinner fa-spin me-2"></i> Saving...';
        submitBtn.disabled = true;
    });
</script>
<?= $this->endSection() ?>