<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="row">
    <div class="col-12">
        <div class="card">
            <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
                <h4 class="mb-0">All Notifications</h4>
                <button class="btn btn-light btn-sm" id="markAllRead">
                    <i class="fas fa-check-circle"></i> Mark all as read
                </button>
            </div>
            <div class="card-body">
                <div class="list-group" id="notificationsList">
                    <!-- Notifications will be loaded here -->
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    // Load notifications when page loads
    loadNotifications();
    
    // Mark all as read button
    const markAllReadBtn = document.getElementById('markAllRead');
    if (markAllReadBtn) {
        markAllReadBtn.addEventListener('click', function() {
            // Get CSRF token
            const csrfToken = document.querySelector('meta[name="X-CSRF-TOKEN"]');
            const csrfHash = csrfToken ? csrfToken.getAttribute('content') : '';
            
            fetch('/dashboard/notifications/mark-read', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-Requested-With': 'XMLHttpRequest',
                    'X-CSRF-TOKEN': csrfHash
                },
                body: JSON.stringify({action: 'mark_all_read'})
            })
            .then(response => response.json())
            .then(data => {
                if (data.success) {
                    // Reload notifications
                    loadNotifications();
                    // Show success message
                    alert('All notifications marked as read');
                }
            })
            .catch(error => {
                console.error('Error marking notifications as read:', error);
                alert('Error marking notifications as read');
            });
        });
    }
    
    // Load notifications from server
    function loadNotifications() {
        fetch('/dashboard/notifications')
            .then(response => response.json())
            .then(data => {
                displayNotifications(data.notifications);
            })
            .catch(error => {
                console.error('Error loading notifications:', error);
                document.getElementById('notificationsList').innerHTML = '<div class="text-center py-5"><p>Error loading notifications</p></div>';
            });
    }
    
    // Display notifications
    function displayNotifications(notifications) {
        const container = document.getElementById('notificationsList');
        
        if (!notifications || notifications.length === 0) {
            container.innerHTML = '<div class="text-center py-5"><p>No notifications found</p></div>';
            return;
        }
        
        let html = '';
        notifications.forEach(notification => {
            let iconClass = 'fa-bell';
            let iconBgClass = 'bg-primary';
            let iconTextClass = 'text-primary';
            
            if (notification.type === 'company') {
                iconClass = 'fa-building';
                iconBgClass = 'bg-primary';
                iconTextClass = 'text-primary';
            } else if (notification.type === 'personnel') {
                iconClass = 'fa-user-plus';
                iconBgClass = 'bg-success';
                iconTextClass = 'text-success';
            } else if (notification.type === 'system') {
                iconClass = 'fa-info-circle';
                iconBgClass = 'bg-info';
                iconTextClass = 'text-info';
            }
            
            html += `
                <div class="list-group-item">
                    <div class="d-flex">
                        <div class="me-3">
                            <div class="p-2 rounded-circle ${iconBgClass} bg-opacity-10">
                                <i class="fas ${iconClass} ${iconTextClass}"></i>
                            </div>
                        </div>
                        <div class="flex-grow-1">
                            <div class="d-flex justify-content-between">
                                <h6 class="mb-1">${notification.title}</h6>
                                <small class="text-muted">${notification.timestamp}</small>
                            </div>
                            <p class="mb-1 text-muted">${notification.message}</p>
                            ${!notification.read ? '<span class="badge bg-primary bg-opacity-10 text-primary">New</span>' : ''}
                        </div>
                    </div>
                </div>
            `;
        });
        
        container.innerHTML = html;
    }
});
</script>
<?= $this->endSection() ?>