<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - Labourdnhdd - CMS</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-light: #5EC9F8;
            --primary-medium: #3A82D4;
            --primary-dark: #214D8C;
            --accent-saffron: #FF9933;
            --accent-green: #138808;
            --jtech-blue: linear-gradient(135deg, #5EC9F8 0%, #3A82D4 50%, #214D8C 100%);
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .login-card {
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.1);
            overflow: hidden;
            border: none;
        }
        
        .brand-header {
            background: var(--jtech-blue);
            color: white;
            text-align: center;
            padding: 2rem 1rem;
        }
        
        .brand-logo {
            background-color: white;
            border-radius: 50%;
            width: 80px;
            height: 80px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
        }
        
        .brand-logo span {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-medium);
        }
        
        .brand-title {
            font-weight: 700;
            margin-bottom: 0.25rem;
        }
        
        .brand-subtitle {
            font-weight: 500;
            opacity: 0.9;
        }
        
        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
        }
        
        .btn-login {
            background: var(--jtech-blue);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-login:hover {
            background: #214D8C;
            transform: translateY(-2px);
            box-shadow: 0 0.25rem 0.5rem rgba(0,0,0,0.1);
        }
        
        .loading-spinner {
            display: none;
            width: 1.5rem;
            height: 1.5rem;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .footer-text {
            color: #6c757d;
            font-size: 0.875rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card login-card">
                    <!-- Header with Logo -->
                    <div class="brand-header">
                        <div class="brand-logo">
                            <span>J</span>
                        </div>
                        <h1 class="h3 brand-title">Labourdnhdd - CMS</h1>
                        <p class="mb-0 brand-subtitle"></p>
                    </div>
                    
                    <!-- Login Form -->
                    <div class="card-body p-4">
                        <h2 class="text-center mb-1">Welcome Back</h2>
                        <p class="text-center text-muted mb-4">Sign in to your account</p>
                        
                        <?php if (session()->getFlashdata('error')): ?>
                            <div class="alert alert-danger">
                                <?= session()->getFlashdata('error') ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>
                        
                        <form action="<?= base_url('/login') ?>" method="post" id="loginForm">
                            <?= csrf_field() ?>
                            
                            <div class="mb-3">
                                <label for="username" class="form-label fw-medium">
                                    <i class="fas fa-user me-2 text-primary"></i>Username
                                </label>
                                <input 
                                    type="text" 
                                    id="username" 
                                    name="username" 
                                    class="form-control"
                                    placeholder="Enter your username"
                                    value="<?= old('username') ?>"
                                    required
                                >
                                <?php if (isset($validation) && $validation->hasError('username')): ?>
                                    <div class="text-danger small mt-1"><?= $validation->getError('username') ?></div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="mb-4">
                                <label for="password" class="form-label fw-medium">
                                    <i class="fas fa-lock me-2 text-primary"></i>Password
                                </label>
                                <input 
                                    type="password" 
                                    id="password" 
                                    name="password" 
                                    class="form-control"
                                    placeholder="Enter your password"
                                    required
                                >
                                <?php if (isset($validation) && $validation->hasError('password')): ?>
                                    <div class="text-danger small mt-1"><?= $validation->getError('password') ?></div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="d-grid mb-3">
                                <button 
                                    type="submit" 
                                    class="btn btn-login" 
                                    id="loginButton"
                                >
                                    <span id="buttonText">Sign In</span>
                                    <span id="loadingSpinner" class="loading-spinner"></span>
                                </button>
                            </div>
                        </form>
                        
                        <div class="text-center">
                            <a href="<?= base_url('/forgot-password') ?>" class="text-decoration-none text-primary">
                                <i class="fas fa-question-circle me-1"></i>Forgot Password?
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-footer text-center">
                        <p class="mb-0 footer-text">&copy; <?= date('Y') ?> Labourdnhdd - CMS. All rights reserved.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Login form submission with loader
        document.addEventListener('DOMContentLoaded', function() {
            const loginForm = document.getElementById('loginForm');
            const loginButton = document.getElementById('loginButton');
            const buttonText = document.getElementById('buttonText');
            const loadingSpinner = document.getElementById('loadingSpinner');
            
            loginForm.addEventListener('submit', function() {
                // Show loader and disable button
                loadingSpinner.style.display = 'inline-block';
                buttonText.textContent = 'Signing In...';
                loginButton.disabled = true;
            });
        });
    </script>
</body>
</html>