<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Forgot Password - Labourdnhdd - CMS</title>
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-light: #5EC9F8;
            --primary-medium: #3A82D4;
            --primary-dark: #214D8C;
            --accent-saffron: #FF9933;
            --accent-green: #138808;
            --jtech-blue: linear-gradient(135deg, #5EC9F8 0%, #3A82D4 50%, #214D8C 100%);
        }
        
        body {
            background: linear-gradient(135deg, #f5f7fa 0%, #e4edf5 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        .forgot-card {
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.1);
            overflow: hidden;
            border: none;
        }
        
        .brand-header {
            background: var(--jtech-blue);
            color: white;
            text-align: center;
            padding: 2rem 1rem;
        }
        
        .brand-logo {
            background-color: white;
            border-radius: 50%;
            width: 80px;
            height: 80px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
        }
        
        .brand-logo span {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-medium);
        }
        
        .brand-title {
            font-weight: 700;
            margin-bottom: 0.25rem;
        }
        
        .brand-subtitle {
            font-weight: 500;
            opacity: 0.9;
        }
        
        .form-control {
            border-radius: 0.5rem;
            padding: 0.75rem 1rem;
        }
        
        .btn-forgot {
            background: var(--jtech-blue);
            border: none;
            border-radius: 0.5rem;
            padding: 0.75rem;
            font-weight: 600;
            transition: all 0.3s ease;
        }
        
        .btn-forgot:hover {
            background: #214D8C;
            transform: translateY(-2px);
            box-shadow: 0 0.25rem 0.5rem rgba(0,0,0,0.1);
        }
        
        .loading-spinner {
            display: none;
            width: 1.5rem;
            height: 1.5rem;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            to { transform: rotate(360deg); }
        }
        
        .footer-text {
            color: #6c757d;
            font-size: 0.875rem;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6 col-lg-4">
                <div class="card forgot-card">
                    <!-- Header with Logo -->
                    <div class="brand-header">
                        <div class="brand-logo">
                            <span>J</span>
                        </div>
                        <h1 class="h3 brand-title">Labourdnhdd - CMS</h1>
                        <p class="mb-0 brand-subtitle">Code Your Vision</p>
                    </div>
                    
                    <!-- Forgot Password Form -->
                    <div class="card-body p-4">
                        <h2 class="text-center mb-1">Forgot Password</h2>
                        <p class="text-center text-muted mb-4">Enter your email to reset your password</p>
                        
                        <?php if (session()->getFlashdata('error')): ?>
                            <div class="alert alert-danger">
                                <?= session()->getFlashdata('error') ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if (session()->getFlashdata('success')): ?>
                            <div class="alert alert-success">
                                <?= session()->getFlashdata('success') ?>
                            </div>
                        <?php endif; ?>
                        
                        <form action="<?= base_url('/forgot-password/send-otp') ?>" method="post" id="forgotPasswordForm">
                            <?= csrf_field() ?>
                            
                            <div class="mb-4">
                                <label for="email" class="form-label fw-medium">
                                    <i class="fas fa-envelope me-2 text-primary"></i>Email Address
                                </label>
                                <input 
                                    type="email" 
                                    id="email" 
                                    name="email" 
                                    class="form-control"
                                    placeholder="Enter your email address"
                                    value="<?= old('email') ?>"
                                    required
                                >
                                <?php if (isset($validation) && $validation->hasError('email')): ?>
                                    <div class="text-danger small mt-1"><?= $validation->getError('email') ?></div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="d-grid mb-3">
                                <button 
                                    type="submit" 
                                    class="btn btn-forgot" 
                                    id="sendOtpButton"
                                >
                                    <span id="buttonText">Send OTP</span>
                                    <span id="loadingSpinner" class="loading-spinner"></span>
                                </button>
                            </div>
                        </form>
                        
                        <div class="text-center">
                            <a href="<?= base_url('/login') ?>" class="text-decoration-none text-primary">
                                <i class="fas fa-arrow-left me-1"></i> Back to Login
                            </a>
                        </div>
                    </div>
                    
                    <div class="card-footer text-center">
                        <p class="mb-0 footer-text">&copy; <?= date('Y') ?> Labourdnhdd - CMS. All rights reserved.</p>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        // Forgot password form submission with loader
        document.addEventListener('DOMContentLoaded', function() {
            const forgotPasswordForm = document.getElementById('forgotPasswordForm');
            const sendOtpButton = document.getElementById('sendOtpButton');
            const buttonText = document.getElementById('buttonText');
            const loadingSpinner = document.getElementById('loadingSpinner');
            
            forgotPasswordForm.addEventListener('submit', function() {
                // Show loader and disable button
                loadingSpinner.style.display = 'inline-block';
                buttonText.textContent = 'Sending OTP...';
                sendOtpButton.disabled = true;
            });
        });
    </script>
</body>
</html>