<!DOCTYPE html>
<html lang="en" data-bs-theme="light">
<head>
    <meta charset="utf-8">
    <title>404 - Page Not Found</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-light: #5EC9F8;
            --primary-medium: #3A82D4;
            --primary-dark: #214D8C;
            --accent-saffron: #FF9933;
            --accent-green: #138808;
            --jtech-blue: linear-gradient(135deg, #5EC9F8 0%, #3A82D4 50%, #214D8C 100%);
        }
        
        body {
            background-color: #f8f9fa;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            transition: background-color 0.3s, color 0.3s;
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        
        body[data-bs-theme="dark"] {
            background-color: #121212;
            color: #e0e0e0;
        }
        
        .error-container {
            max-width: 800px;
            margin: 0 auto;
            padding: 2rem;
        }
        
        .error-card {
            background-color: #fff;
            border-radius: 1rem;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.15);
            overflow: hidden;
            transition: all 0.3s ease;
        }
        
        body[data-bs-theme="dark"] .error-card {
            background-color: #1e1e1e;
            box-shadow: 0 0.5rem 1rem rgba(0,0,0,0.3);
        }
        
        .error-header {
            background: var(--jtech-blue);
            color: white;
            padding: 2rem;
            text-align: center;
        }
        
        .error-icon {
            font-size: 4rem;
            margin-bottom: 1rem;
        }
        
        .error-content {
            padding: 2rem;
        }
        
        .brand-logo {
            background: white;
            border-radius: 50%;
            width: 60px;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 1rem;
        }
        
        .brand-logo span {
            color: var(--primary-dark);
            font-weight: bold;
            font-size: 1.5rem;
        }
        
        .btn-primary {
            background: var(--jtech-blue);
            border: none;
        }
        
        .btn-primary:hover {
            background: #214D8C;
        }
        
        .footer-text {
            color: #6c757d;
            font-size: 0.875rem;
            text-align: center;
            margin-top: 2rem;
        }
        
        body[data-bs-theme="dark"] .footer-text {
            color: #a0a0a0;
        }
    </style>
</head>
<body>
    <div class="error-container">
        <div class="error-card">
            <div class="error-header">
                <div class="brand-logo">
                    <span>J</span>
                </div>
                <h1 class="display-5 fw-bold mb-0">Labourdnhdd - CMS</h1>
            </div>
            
            <div class="error-content text-center">
                <div class="error-icon text-primary">
                    <i class="fas fa-exclamation-triangle"></i>
                </div>
                <h2 class="display-6 fw-bold mb-3">404 - Page Not Found</h2>
                <p class="lead mb-4">Oops! The page you're looking for doesn't exist or has been moved.</p>
                
                <div class="d-grid gap-2 d-sm-flex justify-content-sm-center mb-4">
                    <a href="<?= base_url('/') ?>" class="btn btn-primary btn-lg px-4 gap-3">
                        <i class="fas fa-home me-2"></i>Go to Dashboard
                    </a>
                    <a href="javascript:history.back()" class="btn btn-outline-secondary btn-lg px-4">
                        <i class="fas fa-arrow-left me-2"></i>Go Back
                    </a>
                </div>
                
                <div class="alert alert-info text-start" role="alert">
                    <h5 class="alert-heading">
                        <i class="fas fa-info-circle me-2"></i>Need Help?
                    </h5>
                    <p class="mb-1">Here are some things you can try:</p>
                    <ul class="mb-0">
                        <li>Check that the URL is spelled correctly</li>
                        <li>Go back to the previous page</li>
                        <li>Return to the dashboard</li>
                        <li>Contact your system administrator if the problem persists</li>
                    </ul>
                </div>
            </div>
        </div>
        
        <div class="footer-text">
            <p class="mb-0">&copy; <?= date('Y') ?> Labourdnhdd - CMS. All rights reserved.</p>
        </div>
    </div>

    <!-- Bootstrap 5 JS Bundle with Popper -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>