<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <!-- Page Header -->
    <div class="row">
        <div class="col-12">
            <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
                <h1 class="h2">Session Debug Information</h1>
            </div>
        </div>
    </div>

    <!-- Debug Cards -->
    <div class="row">
        <div class="col-md-6 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="card-title mb-0">Session Data</h5>
                </div>
                <div class="card-body">
                    <pre class="bg-light p-3 border rounded mb-0" style="max-height: 300px; overflow-y: auto;"><?= print_r($_SESSION, true) ?></pre>
                </div>
            </div>
        </div>
        
        <div class="col-md-6 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="card-title mb-0">User Role Check</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label fw-medium">Session Role:</label>
                        <div class="alert alert-info">
                            <?= session()->get('role') ?? 'Not set' ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Is Superadmin:</label>
                        <div class="alert <?= (session()->get('role') === 'superadmin') ? 'alert-success' : 'alert-warning' ?>">
                            <?= (session()->get('role') === 'superadmin') ? 'Yes' : 'No' ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Is Array Check:</label>
                        <div class="alert <?= is_array(session()->get()) ? 'alert-success' : 'alert-warning' ?>">
                            <?= is_array(session()->get()) ? 'Yes' : 'No' ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="card-title mb-0">URI Information</h5>
                </div>
                <div class="card-body">
                    <div class="mb-3">
                        <label class="form-label fw-medium">Current Path:</label>
                        <div class="alert alert-info">
                            <?= service('uri')->getPath() ?>
                        </div>
                    </div>
                    
                    <div class="mb-3">
                        <label class="form-label fw-medium">Admin Path Check:</label>
                        <div class="alert <?= (strpos(service('uri')->getPath(), '/admin') === 0) ? 'alert-success' : 'alert-warning' ?>">
                            <?= (strpos(service('uri')->getPath(), '/admin') === 0) ? 'Yes' : 'No' ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-6 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="card-title mb-0">Navigation</h5>
                </div>
                <div class="card-body d-flex flex-column">
                    <a href="<?= base_url('/dashboard') ?>" class="btn btn-primary mb-2">
                        <i class="fas fa-arrow-left me-2"></i> Back to Dashboard
                    </a>
                    <a href="<?= base_url('/logout') ?>" class="btn btn-outline-danger mt-auto">
                        <i class="fas fa-sign-out-alt me-2"></i> Logout
                    </a>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>