<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <!-- Welcome Section -->
    <div class="row">
        <div class="col-12">
            <div class="card bg-gradient-primary text-white border-0 mb-4" style="background: linear-gradient(135deg, #5EC9F8 0%, #3A82D4 50%, #214D8C 100%);">
                <div class="card-body">
                    <div class="row align-items-center">
                        <div class="col-md-8">
                            <h1 class="display-6 fw-bold mb-2">Welcome back, <?= session()->get('username') ?>!</h1>
                            <p class="lead mb-3">Here's what's happening with your companies today.</p>
                            <div class="d-flex align-items-center">
                                <span class="badge bg-white text-primary me-2">
                                    <i class="fas fa-calendar-alt me-1"></i> <?= date('l, F j, Y') ?>
                                </span>
                                <span class="badge bg-white text-success">
                                    <i class="fas fa-clock me-1"></i> <?= date('g:i A') ?>
                                </span>
                            </div>
                        </div>
                        <div class="col-md-4 text-end d-none d-md-block">
                            <div class="bg-white rounded-circle p-3 d-inline-flex" style="width: 100px; height: 100px;">
                                <span class="text-primary fw-bold m-auto" style="font-size: 2.5rem;">J</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php if (session()->get('role') === 'superadmin'): ?>
    <!-- Admin Management Card -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card border-0 shadow-sm">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center">
                        <div class="d-flex align-items-center">
                            <div class="bg-primary bg-opacity-10 p-3 rounded-circle me-3">
                                <i class="fas fa-user-shield text-primary fs-4"></i>
                            </div>
                            <div>
                                <h5 class="card-title mb-1">Admin Management</h5>
                                <p class="card-text text-muted mb-0">Manage admin users and their permissions</p>
                            </div>
                        </div>
                        <a href="<?= base_url('/admin') ?>" class="btn btn-primary">
                            <i class="fas fa-user-shield me-2"></i> Manage Admins
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <?php endif; ?>

    <!-- Stats Cards -->
    <div class="row mb-4">
        <div class="col-md-4 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="p-3 rounded-circle bg-primary bg-opacity-10">
                            <i class="fas fa-building text-primary fs-4"></i>
                        </div>
                        <div class="text-end">
                            <span class="badge bg-success bg-opacity-10 text-success">
                                <i class="fas fa-arrow-up me-1"></i> 12%
                            </span>
                        </div>
                    </div>
                    <h3 class="mb-1"><?= $stats['total_companies'] ?? 0 ?></h3>
                    <p class="text-muted mb-0">Total Companies</p>
                    <div class="progress mt-3" style="height: 5px;">
                        <div class="progress-bar bg-primary" role="progressbar" style="width: 75%"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="p-3 rounded-circle bg-success bg-opacity-10">
                            <i class="fas fa-users text-success fs-4"></i>
                        </div>
                        <div class="text-end">
                            <span class="badge bg-success bg-opacity-10 text-success">
                                <i class="fas fa-arrow-up me-1"></i> 8%
                            </span>
                        </div>
                    </div>
                    <h3 class="mb-1"><?= $stats['total_personnel'] ?? 0 ?></h3>
                    <p class="text-muted mb-0">Total Employees</p>
                    <div class="progress mt-3" style="height: 5px;">
                        <div class="progress-bar bg-success" role="progressbar" style="width: 65%"></div>
                    </div>
                </div>
            </div>
        </div>
        
        <div class="col-md-4 mb-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <div class="p-3 rounded-circle bg-info bg-opacity-10">
                            <i class="fas fa-chart-line text-info fs-4"></i>
                        </div>
                        <div class="text-end">
                            <span class="badge bg-danger bg-opacity-10 text-danger">
                                <i class="fas fa-arrow-down me-1"></i> 3%
                            </span>
                        </div>
                    </div>
                    <h3 class="mb-1"><?= $stats['total_contractors'] ?? 0 ?></h3>
                    <p class="text-muted mb-0">Active Projects</p>
                    <div class="progress mt-3" style="height: 5px;">
                        <div class="progress-bar bg-info" role="progressbar" style="width: 40%"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Recent Activity -->
        <div class="col-lg-8 mb-4">
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0 py-3">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">Recent Activity</h5>
                        <a href="#" class="text-decoration-none">View All</a>
                    </div>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <?php if (!empty($recent_activity)): ?>
                            <?php foreach ($recent_activity as $activity): ?>
                            <div class="list-group-item border-0 px-0 py-3">
                                <div class="d-flex">
                                    <div class="me-3">
                                        <div class="p-2 rounded-circle <?= $activity['icon_class'] ?> bg-opacity-10">
                                            <i class="fas <?= $activity['icon'] ?> <?= $activity['text_class'] ?>"></i>
                                        </div>
                                    </div>
                                    <div class="flex-grow-1">
                                        <div class="d-flex justify-content-between">
                                            <h6 class="mb-1"><?= $activity['title'] ?></h6>
                                            <small class="text-muted"><?= $activity['time_ago'] ?></small>
                                        </div>
                                        <p class="mb-1 text-muted"><?= $activity['message'] ?></p>
                                        <?php if ($activity['type'] === 'company'): ?>
                                            <span class="badge bg-primary bg-opacity-10 text-primary">New</span>
                                        <?php elseif ($activity['type'] === 'personnel'): ?>
                                            <span class="badge bg-success bg-opacity-10 text-success">Hired</span>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <div class="text-center py-4">
                                <p class="text-muted mb-0">No recent activity to display</p>
                            </div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Pagination Controls -->
                    <?php if (isset($pager) && $pager['totalPages'] > 1): ?>
                    <div class="card-footer bg-white border-0 pt-3">
                        <nav aria-label="Recent activity pagination">
                            <ul class="pagination justify-content-center mb-0">
                                <?php if ($pager['hasPrevious']): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="<?= base_url('/dashboard?page=' . ($pager['currentPage'] - 1)) ?>" aria-label="Previous">
                                            <span aria-hidden="true">&laquo;</span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                                
                                <?php for ($i = 1; $i <= $pager['totalPages']; $i++): ?>
                                    <li class="page-item <?= $i == $pager['currentPage'] ? 'active' : '' ?>">
                                        <a class="page-link" href="<?= base_url('/dashboard?page=' . $i) ?>"><?= $i ?></a>
                                    </li>
                                <?php endfor; ?>
                                
                                <?php if ($pager['hasNext']): ?>
                                    <li class="page-item">
                                        <a class="page-link" href="<?= base_url('/dashboard?page=' . ($pager['currentPage'] + 1)) ?>" aria-label="Next">
                                            <span aria-hidden="true">&raquo;</span>
                                        </a>
                                    </li>
                                <?php endif; ?>
                            </ul>
                        </nav>
                        <div class="text-center mt-2">
                            <small class="text-muted">
                                Showing <?= count($recent_activity) ?> of <?= $pager['total'] ?> activities
                            </small>
                        </div>
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        
        <!-- Quick Actions & Stats -->
        <div class="col-lg-4 mb-4">
            <!-- Quick Actions -->
            <div class="card border-0 shadow-sm mb-4">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="card-title mb-0">Quick Actions</h5>
                </div>
                <div class="card-body">
                    <div class="d-grid gap-2">
                        <a href="<?= base_url('/companies/create') ?>" class="btn btn-outline-primary">
                            <i class="fas fa-plus-circle me-2"></i> Add New Company
                        </a>
                        <a href="<?= base_url('/personnel/create') ?>" class="btn btn-outline-success">
                            <i class="fas fa-user-plus me-2"></i> Add New Employee
                        </a>
                        <a href="<?= base_url('/contractors/create') ?>" class="btn btn-outline-info">
                            <i class="fas fa-hard-hat me-2"></i> Add New Contractor
                        </a>
                        <a href="<?= base_url('/settings') ?>" class="btn btn-outline-secondary">
                            <i class="fas fa-cog me-2"></i> System Settings
                        </a>
                    </div>
                </div>
            </div>
            
            <!-- System Status -->
            <div class="card border-0 shadow-sm">
                <div class="card-header bg-white border-0 py-3">
                    <h5 class="card-title mb-0">System Status</h5>
                </div>
                <div class="card-body">
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span>Database</span>
                        <?php if (isset($system_status['database'])): ?>
                            <span class="badge <?= $system_status['database']['status'] === 'Online' ? 'bg-success' : 'bg-danger' ?>">
                                <?= $system_status['database']['status'] ?>
                            </span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Unknown</span>
                        <?php endif; ?>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span>
                            Storage
                            <?php if (isset($system_status['storage'])): ?>
                                <small class="text-muted d-block"><?= $system_status['storage']['used'] ?> of <?= $system_status['storage']['total'] ?></small>
                            <?php endif; ?>
                        </span>
                        <?php if (isset($system_status['storage'])): ?>
                            <span class="badge <?= $system_status['storage']['percentage'] < 80 ? 'bg-success' : ($system_status['storage']['percentage'] < 90 ? 'bg-warning' : 'bg-danger') ?>">
                                <?= $system_status['storage']['percentage'] ?>%
                            </span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Unknown</span>
                        <?php endif; ?>
                    </div>
                    <div class="d-flex justify-content-between align-items-center mb-3">
                        <span>Backup</span>
                        <?php if (isset($system_status['backup'])): ?>
                            <span class="badge <?= $system_status['backup']['status'] === 'Up to date' ? 'bg-success' : ($system_status['backup']['status'] === 'Recent' ? 'bg-warning' : 'bg-danger') ?>">
                                <?= $system_status['backup']['status'] ?>
                            </span>
                        <?php else: ?>
                            <span class="badge bg-secondary">Unknown</span>
                        <?php endif; ?>
                    </div>
                    <div class="d-flex justify-content-between align-items-center">
                        <span>Last Login</span>
                        <?php if (isset($system_status['last_login'])): ?>
                            <span><?= date('M j, g:i A', strtotime($system_status['last_login'])) ?></span>
                        <?php else: ?>
                            <span>Unknown</span>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>