<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - CMS</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --light-bg: #f8f9fa;
            --dark-bg: #1a202c;
            --light-text: #1a202c;
            --dark-text: #f8f9fa;
            --primary-light: #5EC9F8;
            --primary-medium: #3A82D4;
            --primary-dark: #214D8C;
            --accent-saffron: #FF9933;
            --accent-green: #138808;
        }
        
        .theme-transition * {
            transition: background-color 0.3s ease, color 0.3s ease;
        }
        
        .gradient-bg {
            background: linear-gradient(135deg, var(--primary-light) 0%, var(--primary-medium) 50%, var(--primary-dark) 100%);
        }
        
        /* Desktop sidebar */
        .sidebar {
            transition: all 0.3s ease;
            transform: translateX(-100%);
            z-index: 50;
        }
        
        .sidebar.active {
            transform: translateX(0);
        }
        
        /* Mobile app bottom navigation */
        .mobile-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            background-color: white;
            border-top: 1px solid #e5e7eb;
            z-index: 40;
            display: none;
        }
        
        .dark .mobile-nav {
            background-color: #1f2937;
            border-top: 1px solid #374151;
        }
        
        .mobile-nav-item {
            flex: 1;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            padding: 0.5rem 0;
            color: #6b7280;
            text-decoration: none;
        }
        
        .dark .mobile-nav-item {
            color: #9ca3af;
        }
        
        .mobile-nav-item.active {
            color: var(--primary-medium);
        }
        
        .dark .mobile-nav-item.active {
            color: var(--primary-medium);
        }
        
        .mobile-nav-item i {
            font-size: 1.25rem;
            margin-bottom: 0.25rem;
        }
        
        .mobile-nav-item span {
            font-size: 0.75rem;
        }
        
        /* Mobile app top bar */
        .mobile-top-bar {
            display: none;
            background-color: var(--primary-medium);
            color: white;
            padding: 1rem;
            text-align: center;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            z-index: 30;
        }
        
        .mobile-content {
            margin-top: 0;
            margin-bottom: 0;
        }
        
        /* Sidebar overlay for mobile */
        .sidebar-overlay {
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background-color: rgba(0, 0, 0, 0.5);
            z-index: 45;
            display: none;
        }
        
        .sidebar-overlay.active {
            display: block;
        }
        
        @media (max-width: 767px) {
            .mobile-nav {
                display: flex;
            }
            
            .mobile-top-bar {
                display: block;
            }
            
            .mobile-content {
                margin-top: 3.5rem;
                margin-bottom: 4rem;
            }
        }
        
        @media (min-width: 768px) {
            .sidebar {
                transform: translateX(0);
                width: 250px;
            }
            
            .sidebar.collapsed {
                width: 80px;
            }
            
            .sidebar.collapsed .nav-text {
                display: none;
            }
            
            .sidebar.collapsed .logo-text {
                display: none;
            }
            
            .sidebar.collapsed .logo-icon {
                display: flex;
            }
        }
        
        .content-expanded {
            margin-left: 0;
            transition: margin-left 0.3s ease;
        }
        
        @media (min-width: 768px) {
            .content-expanded {
                margin-left: 0;
            }
            
            .sidebar.active ~ .content-expanded,
            .sidebar:not(.collapsed):not(.active) ~ .content-expanded {
                margin-left: 250px;
            }
            
            .sidebar.collapsed ~ .content-expanded {
                margin-left: 80px;
            }
        }
    </style>
</head>
<body class="theme-transition bg-light min-vh-100">
    <!-- Mobile Top Bar -->
    <div class="mobile-top-bar">
        <div class="d-flex align-items-center justify-content-between">
            <button id="mobileMenuToggle" class="text-white">
                <i class="fas fa-bars"></i>
            </button>
            <h1 class="fs-5 fw-bold flex-fill mx-2">Dashboard</h1>
            <div class="w-6"></div> <!-- Spacer for alignment -->
        </div>
    </div>
    
    <!-- Sidebar Overlay (for mobile) -->
    <div class="sidebar-overlay" id="sidebarOverlay"></div>
    
    <!-- Desktop Sidebar -->
    <div class="sidebar fixed-start h-100 bg-white shadow-lg z-10" style="width: 250px;">
        <div class="p-4 border-bottom">
            <div class="d-flex align-items-center justify-content-between">
                <div class="d-flex align-items-center">
                    <div class="bg-white rounded-circle p-2 w-10 h-10 d-flex align-items-center justify-content-center logo-icon" style="display: none;">
                        <span class="fs-5 fw-bold" style="color: var(--primary-medium);">J</span>
                    </div>
                    <div class="logo-text">
                        <h1 class="fs-5 fw-bold" style="color: var(--primary-medium);">Labourdnhdd - CMS</h1>
                        <p class="text-muted small mb-0">Companies Management System</p>
                    </div>
                </div>
                <!-- Close button for mobile -->
                <button class="d-md-none text-muted" id="sidebarClose">
                    <i class="fas fa-times"></i>
                </button>
            </div>
        </div>
        
        <nav class="mt-4">
            <a href="<?= base_url('/dashboard') ?>" class="d-flex align-items-center px-4 py-3 text-white bg-primary">
                <i class="fas fa-home me-3"></i>
                <span class="nav-text">Dashboard</span>
            </a>
            <a href="#" class="d-flex align-items-center px-4 py-3 text-dark hover-bg-light">
                <i class="fas fa-building me-3"></i>
                <span class="nav-text">Companies</span>
            </a>
            <a href="#" class="d-flex align-items-center px-4 py-3 text-dark hover-bg-light">
                <i class="fas fa-users me-3"></i>
                <span class="nav-text">Employees</span>
            </a>
            <a href="#" class="d-flex align-items-center px-4 py-3 text-dark hover-bg-light">
                <i class="fas fa-chart-bar me-3"></i>
                <span class="nav-text">Reports</span>
            </a>
            <a href="#" class="d-flex align-items-center px-4 py-3 text-dark hover-bg-light">
                <i class="fas fa-cog me-3"></i>
                <span class="nav-text">Settings</span>
            </a>
        </nav>
        
        <div class="position-absolute bottom-0 w-100 p-3 border-top">
            <button id="themeToggle" class="w-100 d-flex align-items-center justify-content-center p-2 rounded bg-secondary bg-opacity-10 text-dark mb-2">
                <i class="fas fa-moon"></i>
            </button>
            <a href="<?= base_url('/logout') ?>" class="w-100 d-flex align-items-center justify-content-center p-2 rounded bg-danger text-white">
                <i class="fas fa-sign-out-alt me-2"></i>
                <span class="nav-text">Logout</span>
            </a>
        </div>
    </div>
    
    <!-- Main Content -->
    <div class="content-expanded">
        <!-- Desktop Top Navbar -->
        <nav class="gradient-bg shadow-lg d-none d-md-block">
            <div class="d-flex align-items-center justify-content-between p-3">
                <div class="d-flex align-items-center">
                    <button id="sidebarToggle" class="text-white me-3">
                        <i class="fas fa-bars fs-5"></i>
                    </button>
                    <h1 class="fs-4 fw-bold text-white">Dashboard</h1>
                </div>
                <div class="d-flex align-items-center gap-3">
                    <div class="text-white">
                        <span>Welcome, <span class="fw-semibold"><?= session()->get('username') ?></span></span>
                    </div>
                    <div class="w-10 h-10 rounded-circle bg-white d-flex align-items-center justify-content-center">
                        <span class="text-dark fw-bold"><?= strtoupper(substr(session()->get('username'), 0, 1)) ?></span>
                    </div>
                </div>
            </div>
        </nav>
        
        <!-- Content Area -->
        <div class="p-4 mobile-content">
            <div class="mb-4">
                <h2 class="fs-3 fw-bold">Companies Management Dashboard</h2>
                <p class="text-muted">Manage your companies and employees efficiently</p>
            </div>

            <?php if (session()->get('role') === 'superadmin'): ?>
            <div class="bg-white rounded shadow-sm p-4 mb-4">
                <div class="d-flex align-items-center justify-content-between">
                    <div>
                        <h3 class="fs-5 fw-semibold">Admin Management</h3>
                        <p class="text-muted mb-0">Manage admin users and their permissions</p>
                    </div>
                    <a href="<?= base_url('/admin') ?>" class="btn btn-primary d-flex align-items-center">
                        <i class="fas fa-user-shield me-2"></i> Manage Admins
                    </a>
                </div>
            </div>
            <?php endif; ?>

            <!-- Stats Cards -->
            <div class="row g-4 mb-4">
                <div class="col-md-4">
                    <div class="bg-white rounded shadow-sm p-4 h-100">
                        <div class="d-flex align-items-center">
                            <div class="p-3 rounded-circle bg-primary bg-opacity-10 me-3">
                                <i class="fas fa-building text-primary fs-4"></i>
                            </div>
                            <div>
                                <h3 class="text-muted fs-6 mb-1">Total Companies</h3>
                                <p class="fs-4 fw-bold mb-0">24</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="bg-white rounded shadow-sm p-4 h-100">
                        <div class="d-flex align-items-center">
                            <div class="p-3 rounded-circle bg-success bg-opacity-10 me-3">
                                <i class="fas fa-users text-success fs-4"></i>
                            </div>
                            <div>
                                <h3 class="text-muted fs-6 mb-1">Total Employees</h3>
                                <p class="fs-4 fw-bold mb-0">142</p>
                            </div>
                        </div>
                    </div>
                </div>
                
                <div class="col-md-4">
                    <div class="bg-white rounded shadow-sm p-4 h-100">
                        <div class="d-flex align-items-center">
                            <div class="p-3 rounded-circle bg-info bg-opacity-10 me-3">
                                <i class="fas fa-chart-line text-info fs-4"></i>
                            </div>
                            <div>
                                <h3 class="text-muted fs-6 mb-1">Active Projects</h3>
                                <p class="fs-4 fw-bold mb-0">8</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Recent Activity -->
            <div class="bg-white rounded shadow-sm p-4">
                <h3 class="fs-5 fw-semibold mb-4">Recent Activity</h3>
                <div class="row g-4">
                    <div class="col-12">
                        <div class="d-flex">
                            <div class="p-2 rounded-circle bg-primary bg-opacity-10 me-3">
                                <i class="fas fa-building text-primary"></i>
                            </div>
                            <div>
                                <h4 class="fw-medium mb-1">New Company Registered</h4>
                                <p class="text-muted mb-1">Tech Solutions Inc. was added to the system</p>
                                <p class="small text-muted mb-0">2 hours ago</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-12">
                        <div class="d-flex">
                            <div class="p-2 rounded-circle bg-success bg-opacity-10 me-3">
                                <i class="fas fa-user-plus text-success"></i>
                            </div>
                            <div>
                                <h4 class="fw-medium mb-1">New Employee Added</h4>
                                <p class="text-muted mb-1">John Doe was added to ABC Corporation</p>
                                <p class="small text-muted mb-0">5 hours ago</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-12">
                        <div class="d-flex">
                            <div class="p-2 rounded-circle bg-info bg-opacity-10 me-3">
                                <i class="fas fa-chart-bar text-info"></i>
                            </div>
                            <div>
                                <h4 class="fw-medium mb-1">Report Generated</h4>
                                <p class="text-muted mb-1">Monthly performance report is ready</p>
                                <p class="small text-muted mb-0">1 day ago</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Mobile Bottom Navigation -->
    <nav class="mobile-nav">
        <a href="<?= base_url('/dashboard') ?>" class="mobile-nav-item active">
            <i class="fas fa-home"></i>
            <span>Home</span>
        </a>
        <a href="#" class="mobile-nav-item">
            <i class="fas fa-building"></i>
            <span>Companies</span>
        </a>
        <a href="#" class="mobile-nav-item">
            <i class="fas fa-users"></i>
            <span>Employees</span>
        </a>
        <a href="#" class="mobile-nav-item">
            <i class="fas fa-cog"></i>
            <span>Settings</span>
        </a>
    </nav>
    
    <!-- Bootstrap 5 JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Theme toggle functionality
        document.getElementById('themeToggle').addEventListener('click', function() {
            document.body.classList.toggle('dark');
            const icon = this.querySelector('i');
            if (document.body.classList.contains('dark')) {
                icon.classList.remove('fa-moon');
                icon.classList.add('fa-sun');
            } else {
                icon.classList.remove('fa-sun');
                icon.classList.add('fa-moon');
            }
        });
        
        // Mobile menu toggle
        document.getElementById('mobileMenuToggle').addEventListener('click', function() {
            document.querySelector('.sidebar').classList.add('active');
            document.getElementById('sidebarOverlay').classList.add('active');
        });
        
        // Close sidebar
        document.getElementById('sidebarClose').addEventListener('click', function() {
            document.querySelector('.sidebar').classList.remove('active');
            document.getElementById('sidebarOverlay').classList.remove('active');
        });
        
        // Close sidebar when clicking overlay
        document.getElementById('sidebarOverlay').addEventListener('click', function() {
            document.querySelector('.sidebar').classList.remove('active');
            this.classList.remove('active');
        });
    </script>
</body>
</html>