<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="d-flex align-items-center mb-4">
        <a href="<?= base_url('/contractors') ?>" 
           class="me-3 text-decoration-none text-muted">
            <i class="fas fa-arrow-left"></i>
        </a>
        <h1 class="h3 mb-0">Contractor Details</h1>
    </div>

    <div class="card border-0 shadow-sm">
        <div class="card-header bg-white border-bottom">
            <h2 class="h4 mb-0">
                <?= esc($contractor['contractor_name']) ?>
            </h2>
            <p class="mb-0 text-muted">
                Contractor for <?= esc($contractor['company_name']) ?>
            </p>
        </div>
        
        <div class="card-body">
            <!-- Company Details Section -->
            <div class="mb-4 p-3 bg-light rounded border">
                <h3 class="h5 mb-3">Company Contact Details</h3>
                <div class="row g-3">
                    <div class="col-md-6">
                        <div class="card border">
                            <div class="card-body">
                                <p class="text-muted mb-1">Company Name</p>
                                <p class="mb-0 fw-medium"><?= esc($contractor['company_name']) ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card border">
                            <div class="card-body">
                                <p class="text-muted mb-1">Contact Email</p>
                                <p class="mb-0 fw-medium text-primary"><?= esc($contractor['company_email'] ?? 'N/A') ?></p>
                            </div>
                        </div>
                    </div>
                    <?php 
                    $hasContactPersons = (!empty($contractor['hr_name']) || !empty($contractor['hr_number']) || 
                                         !empty($contractor['manager_name']) || !empty($contractor['manager_number']));
                    if ($hasContactPersons): ?>
                    <div class="col-12">
                        <h4 class="h6 fw-semibold mb-3">Contact Persons</h4>
                        <div class="row g-3">
                            <?php if (!empty($contractor['hr_name']) || !empty($contractor['hr_number'])): ?>
                            <div class="col-md-6">
                                <div class="card border">
                                    <div class="card-body">
                                        <p class="text-muted mb-1">HR Contact</p>
                                        <p class="mb-0 fw-medium"><?= esc($contractor['hr_name'] ?? 'N/A') ?></p>
                                        <?php if (!empty($contractor['hr_number'])): ?>
                                        <p class="mb-0 text-primary"><?= esc($contractor['hr_number']) ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            
                            <?php if (!empty($contractor['manager_name']) || !empty($contractor['manager_number'])): ?>
                            <div class="col-md-6">
                                <div class="card border">
                                    <div class="card-body">
                                        <p class="text-muted mb-1">Manager Contact</p>
                                        <p class="mb-0 fw-medium"><?= esc($contractor['manager_name'] ?? 'N/A') ?></p>
                                        <?php if (!empty($contractor['manager_number'])): ?>
                                        <p class="mb-0 text-primary"><?= esc($contractor['manager_number']) ?></p>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endif; ?>
                    <div class="col-12">
                        <div class="card border">
                            <div class="card-body">
                                <p class="text-muted mb-1">Registered Address</p>
                                <p class="mb-0 fw-medium"><?= esc($contractor['company_address'] ?? 'N/A') ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border">
                            <div class="card-body">
                                <p class="text-muted mb-1">GST/Tax Number</p>
                                <p class="mb-0 fw-medium"><?= esc($contractor['gst_tax_number'] ?? 'N/A') ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border">
                            <div class="card-body">
                                <p class="text-muted mb-1">Area</p>
                                <p class="mb-0 fw-medium"><?= esc($contractor['area'] ?? 'N/A') ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="card border">
                            <div class="card-body">
                                <p class="text-muted mb-1">Total Workers</p>
                                <p class="mb-0 fw-medium"><?= esc($contractor['total_workers'] ?? 0) ?></p>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="card border">
                            <div class="card-body">
                                <p class="text-muted mb-1">Contractual Workers</p>
                                <p class="mb-0 fw-medium"><?= esc($contractor['contractual_workers'] ?? 0) ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="row g-3">
                <!-- Registration Number -->
                <div class="col-md-6">
                    <label class="form-label text-muted">Registration Number</label>
                    <p class="mb-0"><?= esc($contractor['registration_number'] ?? 'N/A') ?></p>
                </div>
                
                <!-- Sr. No. of Contractor -->
                <div class="col-md-6">
                    <label class="form-label text-muted">Sr. No. of Contractor</label>
                    <p class="mb-0"><?= esc($contractor['sr_no_contractor'] ?? 'N/A') ?></p>
                </div>
                
                <!-- Contractor Contact No -->
                <div class="col-md-6">
                    <label class="form-label text-muted">Contractor Contact No</label>
                    <p class="mb-0"><?= esc($contractor['contractor_contact_no'] ?? 'N/A') ?></p>
                </div>
                
                <!-- Validity Date -->
                <div class="col-md-6">
                    <label class="form-label text-muted">Validity Date</label>
                    <p class="mb-0"><?= esc($contractor['validity_date'] ?? 'N/A') ?></p>
                </div>
                
                <!-- Number of Employees -->
                <div class="col-md-6">
                    <label class="form-label text-muted">Number of Employees</label>
                    <p class="mb-0"><?= esc($contractor['number_of_employees']) ?></p>
                </div>
                
                <!-- No. of Contract Labours -->
                <div class="col-md-6">
                    <label class="form-label text-muted">No. of Contract Labours</label>
                    <p class="mb-0"><?= esc($contractor['no_of_contract_labours']) ?></p>
                </div>
                
                <!-- Less than 20 -->
                <div class="col-md-6">
                    <label class="form-label text-muted">Less than 20</label>
                    <p class="mb-0"><?= esc($contractor['less_than_20']) ?></p>
                </div>
                
                <!-- 20 and above -->
                <div class="col-md-6">
                    <label class="form-label text-muted">20 and above</label>
                    <p class="mb-0"><?= esc($contractor['twenty_and_above']) ?></p>
                </div>
                
                <!-- Nature of Work -->
                <div class="col-12">
                    <label class="form-label text-muted">Nature of Work</label>
                    <p class="mb-0"><?= esc($contractor['nature_of_work'] ?? 'N/A') ?></p>
                </div>
                
                <!-- Contractor Address -->
                <div class="col-12">
                    <label class="form-label text-muted">Contractor Address</label>
                    <p class="mb-0"><?= esc($contractor['contractor_address'] ?? 'N/A') ?></p>
                </div>
                
                <!-- Remarks -->
                <div class="col-12">
                    <label class="form-label text-muted">Remarks</label>
                    <p class="mb-0"><?= esc($contractor['remarks'] ?? 'N/A') ?></p>
                </div>
            </div>
            
            <!-- Created and Updated Info -->
            <div class="row g-3 mt-4 pt-4 border-top">
                <div class="col-md-6">
                    <label class="form-label text-muted">Created At</label>
                    <p class="mb-0"><?= date('M j, Y H:i:s', strtotime($contractor['created_at'])) ?></p>
                </div>
                <div class="col-md-6">
                    <label class="form-label text-muted">Last Updated</label>
                    <p class="mb-0"><?= date('M j, Y H:i:s', strtotime($contractor['updated_at'])) ?></p>
                </div>
            </div>
        </div>
        
        <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
        <div class="card-footer bg-light border-top d-flex justify-content-end gap-2">
            <a href="<?= base_url('/contractors/edit/' . $contractor['id']) ?>" 
               class="btn btn-primary">
                <i class="fas fa-edit me-2"></i> Edit Contractor
            </a>
        </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>