<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="d-flex flex-column flex-md-row align-items-md-center justify-content-between mb-4">
        <div>
            <h1 class="h3">Contractors Management</h1>
            <p class="text-muted">Manage contractors for companies</p>
        </div>
        <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
        <div class="mt-3 mt-md-0">
            <a href="<?= base_url('/contractors/create') ?>" 
               class="btn btn-primary">
                <i class="fas fa-plus me-2"></i> Add New Contractor
            </a>
        </div>
        <?php endif; ?>
    </div>

    <!-- Stats Cards -->
    <div class="row g-4 mb-4">
        <div class="col-md-4">
            <div class="card border-0 shadow-sm h-100">
                <div class="card-body">
                    <div class="d-flex align-items-center">
                        <div class="p-3 rounded bg-primary bg-opacity-10">
                            <i class="fas fa-hard-hat text-primary fs-4"></i>
                        </div>
                        <div class="ms-3">
                            <h6 class="text-muted mb-1">Total Contractors</h6>
                            <p class="h4 mb-0"><?= count($contractors) ?? 0 ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filters -->
    <div class="card border-0 shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" action="<?= base_url('/contractors') ?>" class="row g-3">
                <div class="col-md-4">
                    <label for="search" class="form-label">Search</label>
                    <input type="text" name="search" id="search" 
                           class="form-control"
                           placeholder="Search contractors..." value="<?= esc($search ?? '') ?>">
                </div>
                
                <div class="col-md-4">
                    <label for="company_id" class="form-label">Company</label>
                    <select name="company_id" id="company_id" 
                            class="form-select">
                        <option value="">All Companies</option>
                        <?php foreach ($companies as $company): ?>
                            <option value="<?= $company['id'] ?>" <?= (isset($company_id) && $company_id == $company['id']) ? 'selected' : '' ?>>
                                <?= esc($company['company_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                
                <div class="col-md-4 d-flex align-items-end">
                    <button type="submit" 
                            class="btn btn-primary me-2">
                        <i class="fas fa-filter me-2"></i> Filter
                    </button>
                    <a href="<?= base_url('/contractors') ?>" 
                       class="btn btn-secondary me-2">
                        Reset
                    </a>
                    <div class="btn-group" role="group">
                        <a href="<?= base_url('/contractors/export/csv') ?><?= !empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : '' ?>" 
                           class="btn btn-success">
                            <i class="fas fa-file-excel me-2"></i> Excel
                        </a>
                        <a href="<?= base_url('/contractors/export/pdf') ?><?= !empty($_SERVER['QUERY_STRING']) ? '?' . $_SERVER['QUERY_STRING'] : '' ?>" 
                           class="btn btn-danger">
                            <i class="fas fa-file-pdf me-2"></i> PDF
                        </a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <!-- Contractors Table -->
    <div class="card border-0 shadow-sm">
        <div class="table-responsive">
            <table class="table table-hover align-middle mb-0 datatable">
                <thead class="table-light">
                    <tr>
                        <th scope="col">Sr. No</th>
                        <th scope="col">Reg. No</th>
                        <th scope="col">Contractor Name</th>
                        <th scope="col">Company</th>
                        <th scope="col">Validity Date</th>
                        <th scope="col">No. of Employees</th>
                        <th scope="col">Actions</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (!empty($contractors)): ?>
                        <?php $srNo = 1; ?>
                        <?php foreach ($contractors as $contractor): ?>
                        <tr>
                            <td><?= $srNo++ ?></td>
                            <td><?= esc($contractor['registration_number'] ?? 'N/A') ?></td>
                            <td class="fw-medium"><?= esc($contractor['contractor_name']) ?></td>
                            <td><?= esc($contractor['company_name']) ?></td>
                            <td><?= esc($contractor['validity_date'] ?? 'N/A') ?></td>
                            <td><?= esc($contractor['number_of_employees']) ?></td>
                            <td>
                                <a href="<?= base_url('/contractors/view/' . $contractor['id']) ?>" 
                                   class="btn btn-sm btn-outline-primary me-1">
                                    <i class="fas fa-eye"></i> View
                                </a>
                                <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
                                <a href="<?= base_url('/contractors/edit/' . $contractor['id']) ?>" 
                                   class="btn btn-sm btn-outline-secondary me-1">
                                    <i class="fas fa-edit"></i> Edit
                                </a>
                                <a href="<?= base_url('/contractors/delete/' . $contractor['id']) ?>" 
                                   class="btn btn-sm btn-outline-danger"
                                   onclick="return confirm('Are you sure you want to delete this contractor?')">
                                    <i class="fas fa-trash"></i> Delete
                                </a>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr>
                            <td colspan="7" class="text-center py-4 text-muted">
                                No contractors found.
                            </td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
        
        <!-- Pagination handled by DataTables -->
    </div>
</div>
<?= $this->endSection() ?>