<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="d-flex align-items-center mb-4">
        <a href="<?= base_url('/contractors') ?>" 
           class="me-3 text-decoration-none text-muted">
            <i class="fas fa-arrow-left"></i>
        </a>
        <h1 class="h3 mb-0">Add New Contractor</h1>
    </div>

    <?php if (session()->getFlashdata('error')): ?>
        <div class="alert alert-danger">
            <?= session()->getFlashdata('error') ?>
        </div>
    <?php endif; ?>

    <div class="card border-0 shadow-sm">
        <div class="card-body">
            <form action="<?= base_url('/contractors/store') ?>" method="POST">
                <?= csrf_field() ?>
                
                <div class="row g-3">
                    <!-- Company -->
                    <div class="col-12">
                        <label for="company_id" class="form-label">
                            Company <span class="text-danger">*</span>
                        </label>
                        <select name="company_id" id="company_id" required class="form-select">
                            <option value="">Select a company</option>
                            <?php foreach ($companies as $company): ?>
                                <option value="<?= $company['id'] ?>" <?= (old('company_id') == $company['id']) ? 'selected' : '' ?>>
                                    <?= esc($company['company_name']) ?>
                                </option>
                            <?php endforeach; ?>
                        </select>
                        <?php if (isset($validation) && $validation->hasError('company_id')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('company_id') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Registration Number -->
                    <div class="col-md-6">
                        <label for="registration_number" class="form-label">
                            Registration Number
                        </label>
                        <input type="text" name="registration_number" id="registration_number" 
                               value="<?= old('registration_number') ?>" class="form-control"
                               placeholder="Enter registration number">
                        <?php if (isset($validation) && $validation->hasError('registration_number')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('registration_number') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Contractor Name -->
                    <div class="col-md-6">
                        <label for="contractor_name" class="form-label">
                            Contractor Name <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="contractor_name" id="contractor_name" 
                               value="<?= old('contractor_name') ?>" required class="form-control"
                               placeholder="Enter contractor name">
                        <?php if (isset($validation) && $validation->hasError('contractor_name')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('contractor_name') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Contractor Contact No -->
                    <div class="col-md-6">
                        <label for="contractor_contact_no" class="form-label">
                            Contractor Contact No
                        </label>
                        <input type="text" name="contractor_contact_no" id="contractor_contact_no" 
                               value="<?= old('contractor_contact_no') ?>" class="form-control"
                               placeholder="Enter contractor contact number">
                        <?php if (isset($validation) && $validation->hasError('contractor_contact_no')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('contractor_contact_no') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Contractor Address -->
                    <div class="col-12">
                        <label for="contractor_address" class="form-label">
                            Contractor Address
                        </label>
                        <textarea name="contractor_address" id="contractor_address" rows="3" class="form-control"
                                  placeholder="Enter contractor address"><?= old('contractor_address') ?></textarea>
                        <?php if (isset($validation) && $validation->hasError('contractor_address')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('contractor_address') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Validity Date -->
                    <div class="col-md-6">
                        <label for="validity_date" class="form-label">
                            Validity Date
                        </label>
                        <input type="date" name="validity_date" id="validity_date" 
                               value="<?= old('validity_date') ?>" class="form-control">
                        <?php if (isset($validation) && $validation->hasError('validity_date')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('validity_date') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Number of Employees -->
                    <div class="col-md-6">
                        <label for="number_of_employees" class="form-label">
                            Number of Employees
                        </label>
                        <input type="number" name="number_of_employees" id="number_of_employees" 
                               value="<?= old('number_of_employees', 0) ?>" min="0" class="form-control">
                        <?php if (isset($validation) && $validation->hasError('number_of_employees')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('number_of_employees') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Sr. No. of Contractor -->
                    <div class="col-md-6">
                        <label for="sr_no_contractor" class="form-label">
                            Sr. No. of Contractor
                        </label>
                        <input type="text" name="sr_no_contractor" id="sr_no_contractor" 
                               value="<?= old('sr_no_contractor') ?>" class="form-control"
                               placeholder="Enter Sr. No.">
                        <?php if (isset($validation) && $validation->hasError('sr_no_contractor')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('sr_no_contractor') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Nature of Work -->
                    <div class="col-12">
                        <label for="nature_of_work" class="form-label">
                            Nature of Work
                        </label>
                        <textarea name="nature_of_work" id="nature_of_work" rows="2" class="form-control"
                                  placeholder="Enter nature of work"><?= old('nature_of_work') ?></textarea>
                        <?php if (isset($validation) && $validation->hasError('nature_of_work')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('nature_of_work') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- No. of Contract Labours -->
                    <div class="col-md-4">
                        <label for="no_of_contract_labours" class="form-label">
                            No. of Contract Labours
                        </label>
                        <input type="number" name="no_of_contract_labours" id="no_of_contract_labours" 
                               value="<?= old('no_of_contract_labours', 0) ?>" min="0" class="form-control">
                        <?php if (isset($validation) && $validation->hasError('no_of_contract_labours')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('no_of_contract_labours') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Less than 20 -->
                    <div class="col-md-4">
                        <label for="less_than_20" class="form-label">
                            Less than 20
                        </label>
                        <input type="number" name="less_than_20" id="less_than_20" 
                               value="<?= old('less_than_20', 0) ?>" min="0" class="form-control">
                        <?php if (isset($validation) && $validation->hasError('less_than_20')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('less_than_20') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- 20 and above -->
                    <div class="col-md-4">
                        <label for="twenty_and_above" class="form-label">
                            20 and above
                        </label>
                        <input type="number" name="twenty_and_above" id="twenty_and_above" 
                               value="<?= old('twenty_and_above', 0) ?>" min="0" class="form-control">
                        <?php if (isset($validation) && $validation->hasError('twenty_and_above')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('twenty_and_above') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <!-- Remarks -->
                    <div class="col-12">
                        <label for="remarks" class="form-label">
                            Remarks
                        </label>
                        <textarea name="remarks" id="remarks" rows="2" class="form-control"
                                  placeholder="Enter remarks"><?= old('remarks') ?></textarea>
                        <?php if (isset($validation) && $validation->hasError('remarks')): ?>
                            <div class="text-danger small mt-1"><?= $validation->getError('remarks') ?></div>
                        <?php endif; ?>
                    </div>
                    
                    <div class="col-12">
                        <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                            <a href="<?= base_url('/contractors') ?>" class="btn btn-secondary me-md-2">Cancel</a>
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save me-2"></i> Save Contractor
                            </button>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>
</div>
<?= $this->endSection() ?>