<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Company Details</h1>
    <div class="d-flex gap-2">
        <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
        <a href="<?= base_url('/companies/edit/' . $company['id']) ?>" class="btn btn-primary">
            <i class="fas fa-edit me-2"></i> Edit
        </a>
        <?php endif; ?>
        <a href="<?= base_url('/companies') ?>" class="btn btn-secondary">
            <i class="fas fa-arrow-left me-2"></i> Back to Companies
        </a>
    </div>
</div>

<!-- Success/Error Messages -->
<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <strong>Success!</strong> <?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Error!</strong> <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<!-- Company Details -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <div class="row g-4">
            <div class="col-md-6">
                <h2 class="h4 mb-4">Company Information</h2>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Company Name</label>
                    <p class="mb-0 fs-5"><?= esc($company['company_name']) ?></p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Company Address</label>
                    <p class="mb-0"><?= nl2br(esc($company['company_address'])) ?></p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Area</label>
                    <p class="mb-0"><?= $company['area'] ?></p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Company Email</label>
                    <p class="mb-0"><?= esc($company['company_email']) ?></p>
                </div>
                
                <?php if (!empty($company['hr_name']) || !empty($company['hr_number'])): ?>
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">HR Contact</label>
                    <p class="mb-0">
                        <?= !empty($company['hr_name']) ? esc($company['hr_name']) : '' ?>
                        <?= !empty($company['hr_number']) ? ' (' . esc($company['hr_number']) . ')' : '' ?>
                    </p>
                </div>
                <?php endif; ?>
                
                <?php if (!empty($company['manager_name']) || !empty($company['manager_number'])): ?>
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Manager Contact</label>
                    <p class="mb-0">
                        <?= !empty($company['manager_name']) ? esc($company['manager_name']) : '' ?>
                        <?= !empty($company['manager_number']) ? ' (' . esc($company['manager_number']) . ')' : '' ?>
                    </p>
                </div>
                <?php endif; ?>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">GST/Tax Number</label>
                    <p class="mb-0"><?= $company['gst_tax_number'] ?? '-' ?></p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Notes</label>
                    <p class="mb-0"><?= $company['notes'] ?? '-' ?></p>
                </div>
            </div>
            
            <div class="col-md-6">
                <h2 class="h4 mb-4">Statistics</h2>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Total Workers</label>
                    <p class="mb-0 fs-5"><?= $company['total_workers'] ?></p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Contractual Workers</label>
                    <p class="mb-0 fs-5"><?= $company['contractual_workers'] ?></p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Payroll Workers</label>
                    <p class="mb-0 fs-5"><?= $company['payroll'] ?? '0' ?></p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Status</label>
                    <p class="mb-0">
                        <?php if ($company['status'] === 'Active'): ?>
                            <span class="badge bg-success">Active</span>
                        <?php else: ?>
                            <span class="badge bg-danger">Inactive</span>
                        <?php endif; ?>
                    </p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Created At</label>
                    <p class="mb-0">
                        <?= $company['created_at'] ? date('M j, Y g:i A', strtotime($company['created_at'])) : '-' ?>
                    </p>
                </div>
                
                <div class="mb-3">
                    <label class="form-label fw-medium text-muted">Updated At</label>
                    <p class="mb-0">
                        <?= $company['updated_at'] ? date('M j, Y g:i A', strtotime($company['updated_at'])) : '-' ?>
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Personnel Management Section -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="h4 mb-0">Personnel Management</h2>
            <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
            <a href="<?= base_url('/companies/' . $company['id'] . '/personnel/create') ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i> Add New Personnel
            </a>
            <?php endif; ?>
        </div>
        
        <?php if (!empty($personnel)): ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Name</th>
                            <th>Role</th>
                            <th>Email</th>
                            <th>Phone</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($personnel as $p): ?>
                            <tr>
                                <td class="fw-medium"><?= esc($p['name']) ?></td>
                                <td>
                                    <?php if ($p['role'] === 'Manager'): ?>
                                        <span class="badge bg-primary">Manager</span>
                                    <?php elseif ($p['role'] === 'HR'): ?>
                                        <span class="badge bg-success">HR</span>
                                    <?php elseif ($p['role'] === 'Owner'): ?>
                                        <span class="badge bg-info">Owner</span>
                                    <?php else: ?>
                                        <span class="badge bg-secondary"><?= $p['role'] ?></span>
                                    <?php endif; ?>
                                </td>
                                <td><?= $p['email'] ?? '-' ?></td>
                                <td><?= $p['phone'] ?? '-' ?></td>
                                <td>
                                    <?php if ($p['status'] === 'Active'): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Left</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?= base_url('/personnel/view/' . $p['id']) ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-users fa-2x text-muted mb-3"></i>
                <p class="mb-0 text-muted">No personnel found for this company.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Units Management Section -->
<div class="card border-0 shadow-sm mb-4">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="h4 mb-0">Units Management</h2>
            <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
            <a href="<?= base_url('/companies/' . $company['id'] . '/units/create') ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i> Add New Unit
            </a>
            <?php endif; ?>
        </div>
        
        <?php if (!empty($units)): ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Unit Name</th>
                            <th>Manager</th>
                            <th>Contact</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($units as $unit): ?>
                            <tr>
                                <td class="fw-medium"><?= esc($unit['unit_name']) ?></td>
                                <td><?= esc($unit['unit_manager_name'] ?? '-') ?></td>
                                <td>
                                    <?= $unit['unit_manager_email'] ?? '' ?>
                                    <?= $unit['unit_manager_phone'] ? ($unit['unit_manager_email'] ? '<br>' : '') . $unit['unit_manager_phone'] : '' ?>
                                </td>
                                <td>
                                    <?php if ($unit['status'] === 'Active'): ?>
                                        <span class="badge bg-success">Active</span>
                                    <?php else: ?>
                                        <span class="badge bg-danger">Inactive</span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <a href="<?= base_url('/units/view/' . $unit['id']) ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-building fa-2x text-muted mb-3"></i>
                <p class="mb-0 text-muted">No units found for this company.</p>
            </div>
        <?php endif; ?>
    </div>
</div>

<!-- Contractors Management Section -->
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2 class="h4 mb-0">Contractors Management</h2>
            <?php if (in_array(session()->get('role'), ['admin', 'superadmin'])): ?>
            <a href="<?= base_url('/companies/' . $company['id'] . '/contractors/create') ?>" class="btn btn-primary">
                <i class="fas fa-plus me-2"></i> Add New Contractor
            </a>
            <?php endif; ?>
        </div>
        
        <?php if (!empty($contractors)): ?>
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>Name</th>
                            <th>Work Type</th>
                            <th>Contact</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($contractors as $contractor): ?>
                            <tr>
                                <td class="fw-medium"><?= esc($contractor['contractor_name']) ?></td>
                                <td><?= esc($contractor['nature_of_work'] ?? '-') ?></td>
                                <td>
                                    <?= $contractor['contractor_contact_no'] ?? '' ?>
                                </td>
                                <td>
                                    <span class="badge bg-secondary">N/A</span>
                                </td>
                                <td>
                                    <a href="<?= base_url('/contractors/view/' . $contractor['id']) ?>" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php else: ?>
            <div class="text-center py-5">
                <i class="fas fa-hard-hat fa-2x text-muted mb-3"></i>
                <p class="mb-0 text-muted">No contractors found for this company.</p>
            </div>
        <?php endif; ?>
    </div>
</div>
<?= $this->endSection() ?>