<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Company</h1>
    <a href="<?= base_url('/companies') ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-2"></i> Back to Companies
    </a>
</div>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<div class="card border-0 shadow-sm">
    <div class="card-body">
        <form action="<?= base_url('/companies/update/' . $company['id']) ?>" method="post">
            <?= csrf_field() ?>
            
            <div class="row g-4">
                <!-- Company Name -->
                <div class="col-md-6">
                    <label for="company_name" class="form-label">Company Name <span class="text-danger">*</span></label>
                    <input type="text" name="company_name" id="company_name" value="<?= old('company_name', $company['company_name']) ?>" required class="form-control">
                    <?php if (isset($validation) && $validation->hasError('company_name')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('company_name') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Area -->
                <div class="col-md-6">
                    <label for="area" class="form-label">Area <span class="text-danger">*</span></label>
                    <select name="area" id="area" required class="form-select">
                        <option value="">Select an Area</option>
                        <?php foreach ($areas as $areaOption): ?>
                            <option value="<?= $areaOption ?>" <?= (old('area', $company['area']) === $areaOption) ? 'selected' : '' ?>><?= $areaOption ?></option>
                        <?php endforeach; ?>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('area')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('area') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Company Address -->
                <div class="col-12">
                    <label for="company_address" class="form-label">Company Address <span class="text-danger">*</span></label>
                    <textarea name="company_address" id="company_address" rows="3" required class="form-control"><?= old('company_address', $company['company_address']) ?></textarea>
                    <?php if (isset($validation) && $validation->hasError('company_address')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('company_address') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Company Email -->
                <div class="col-md-6">
                    <label for="company_email" class="form-label">Company Email <span class="text-danger">*</span></label>
                    <input type="email" name="company_email" id="company_email" value="<?= old('company_email', $company['company_email']) ?>" required class="form-control">
                    <?php if (isset($validation) && $validation->hasError('company_email')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('company_email') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- HR Name -->
                <div class="col-md-6">
                    <label for="hr_name" class="form-label">HR Name</label>
                    <input type="text" name="hr_name" id="hr_name" value="<?= old('hr_name', $company['hr_name']) ?>" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('hr_name')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('hr_name') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- HR Number -->
                <div class="col-md-6">
                    <label for="hr_number" class="form-label">HR Number</label>
                    <input type="text" name="hr_number" id="hr_number" value="<?= old('hr_number', $company['hr_number']) ?>" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('hr_number')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('hr_number') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Manager Name -->
                <div class="col-md-6">
                    <label for="manager_name" class="form-label">Manager Name</label>
                    <input type="text" name="manager_name" id="manager_name" value="<?= old('manager_name', $company['manager_name']) ?>" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('manager_name')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('manager_name') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Manager Number -->
                <div class="col-md-6">
                    <label for="manager_number" class="form-label">Manager Number</label>
                    <input type="text" name="manager_number" id="manager_number" value="<?= old('manager_number', $company['manager_number']) ?>" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('manager_number')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('manager_number') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- GST/Tax Number -->
                <div class="col-md-6">
                    <label for="gst_tax_number" class="form-label">GST/Tax Number</label>
                    <input type="text" name="gst_tax_number" id="gst_tax_number" value="<?= old('gst_tax_number', $company['gst_tax_number']) ?>" placeholder="15 character alphanumeric" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('gst_tax_number')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('gst_tax_number') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Total Workers -->
                <div class="col-md-4">
                    <label for="total_workers" class="form-label">Total Workers <span class="text-danger">*</span></label>
                    <input type="number" name="total_workers" id="total_workers" value="<?= old('total_workers', $company['total_workers']) ?>" min="0" required class="form-control">
                    <?php if (isset($validation) && $validation->hasError('total_workers')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('total_workers') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Contractual Workers -->
                <div class="col-md-4">
                    <label for="contractual_workers" class="form-label">Contractual Workers <span class="text-danger">*</span></label>
                    <input type="number" name="contractual_workers" id="contractual_workers" value="<?= old('contractual_workers', $company['contractual_workers']) ?>" min="0" required class="form-control">
                    <?php if (isset($validation) && $validation->hasError('contractual_workers')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('contractual_workers') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Payroll Workers -->
                <div class="col-md-4">
                    <label for="payroll" class="form-label">Payroll Workers</label>
                    <input type="number" name="payroll" id="payroll" value="<?= old('payroll', $company['payroll']) ?>" min="0" class="form-control">
                    <?php if (isset($validation) && $validation->hasError('payroll')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('payroll') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Status -->
                <div class="col-md-6">
                    <label for="status" class="form-label">Status <span class="text-danger">*</span></label>
                    <select name="status" id="status" required class="form-select">
                        <option value="Active" <?= (old('status', $company['status']) === 'Active') ? 'selected' : '' ?>>Active</option>
                        <option value="Inactive" <?= (old('status', $company['status']) === 'Inactive') ? 'selected' : '' ?>>Inactive</option>
                    </select>
                    <?php if (isset($validation) && $validation->hasError('status')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('status') ?></div>
                    <?php endif; ?>
                </div>
                
                <!-- Notes -->
                <div class="col-12">
                    <label for="notes" class="form-label">Notes</label>
                    <textarea name="notes" id="notes" rows="3" class="form-control"><?= old('notes', $company['notes']) ?></textarea>
                    <?php if (isset($validation) && $validation->hasError('notes')): ?>
                        <div class="text-danger small mt-1"><?= $validation->getError('notes') ?></div>
                    <?php endif; ?>
                </div>
                
                <div class="col-12">
                    <div class="d-grid gap-2 d-md-flex justify-content-md-end">
                        <a href="<?= base_url('/companies') ?>" class="btn btn-secondary me-md-2">Cancel</a>
                        <button type="submit" class="btn btn-primary">Update Company</button>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?= $this->endSection() ?>