<?= $this->extend('layouts/dashboard') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h1 class="h3">Edit Admin</h1>
    <a href="<?= base_url('/admin') ?>" class="btn btn-secondary">
        <i class="fas fa-arrow-left me-2"></i> Back to Admins
    </a>
</div>

<!-- Error Messages -->
<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <strong>Error!</strong> <?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
<?php endif; ?>

<!-- Admin Edit Form -->
<div class="card border-0 shadow-sm">
    <div class="card-body">
        <form id="adminForm" action="<?= base_url('/admin/update/' . $admin['id']) ?>" method="POST">
            <?= csrf_field() ?>
            
            <div class="mb-3">
                <label class="form-label" for="username">
                    Username
                </label>
                <input class="form-control <?= isset($validation) && $validation->hasError('username') ? 'is-invalid' : '' ?>" 
                       id="username" 
                       type="text" 
                       name="username" 
                       value="<?= old('username', $admin['username']) ?>"
                       placeholder="Enter username">
                <?php if (isset($validation) && $validation->hasError('username')): ?>
                    <div class="invalid-feedback"><?= $validation->getError('username') ?></div>
                <?php endif; ?>
            </div>
            
            <div class="mb-3">
                <label class="form-label" for="email">
                    Email
                </label>
                <input class="form-control <?= isset($validation) && $validation->hasError('email') ? 'is-invalid' : '' ?>" 
                       id="email" 
                       type="email" 
                       name="email" 
                       value="<?= old('email', $admin['email']) ?>"
                       placeholder="Enter email">
                <?php if (isset($validation) && $validation->hasError('email')): ?>
                    <div class="invalid-feedback"><?= $validation->getError('email') ?></div>
                <?php endif; ?>
            </div>
            
            <div class="mb-3">
                <label class="form-label" for="password">
                    Password (Leave blank to keep current password)
                </label>
                <input class="form-control <?= isset($validation) && $validation->hasError('password') ? 'is-invalid' : '' ?>" 
                       id="password" 
                       type="password" 
                       name="password" 
                       placeholder="Enter new password">
                <?php if (isset($validation) && $validation->hasError('password')): ?>
                    <div class="invalid-feedback"><?= $validation->getError('password') ?></div>
                <?php endif; ?>
                <div class="form-text">
                    Password must be at least 12 characters long and contain at least one uppercase letter, one lowercase letter, one number, and one special character.
                </div>
            </div>
            
            <div class="mb-4">
                <label class="form-label" for="confirm_password">
                    Confirm Password
                </label>
                <input class="form-control <?= isset($validation) && $validation->hasError('confirm_password') ? 'is-invalid' : '' ?>" 
                       id="confirm_password" 
                       type="password" 
                       name="confirm_password" 
                       placeholder="Confirm new password">
                <?php if (isset($validation) && $validation->hasError('confirm_password')): ?>
                    <div class="invalid-feedback"><?= $validation->getError('confirm_password') ?></div>
                <?php endif; ?>
            </div>
            
            <div class="d-grid">
                <button id="submitBtn" class="btn btn-primary" type="submit">
                    <span id="submitText">Update Admin</span>
                    <span id="submitSpinner" class="spinner-border spinner-border-sm d-none" role="status" aria-hidden="true"></span>
                </button>
            </div>
        </form>
    </div>
</div>

<script>
    // Form submission with loading indicator
    document.getElementById('adminForm').addEventListener('submit', function(e) {
        const submitBtn = document.getElementById('submitBtn');
        const submitText = document.getElementById('submitText');
        const submitSpinner = document.getElementById('submitSpinner');
        
        // Show loading indicator
        submitText.textContent = 'Updating...';
        submitSpinner.classList.remove('d-none');
        submitBtn.disabled = true;
    });
</script>
<?= $this->endSection() ?>