<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class SettingsSeeder extends Seeder
{
    public function run()
    {
        $data = [
            [
                'setting_key' => 'app_name',
                'setting_value' => 'Labourdnhdd - CMS',
                'setting_type' => 'string',
                'description' => 'Application Name',
            ],
            [
                'setting_key' => 'app_theme',
                'setting_value' => 'auto',
                'setting_type' => 'string',
                'description' => 'Application Theme',
            ],
            [
                'setting_key' => 'timezone',
                'setting_value' => 'Asia/Kolkata',
                'setting_type' => 'string',
                'description' => 'Timezone',
            ],
            [
                'setting_key' => 'email_notifications',
                'setting_value' => '1',
                'setting_type' => 'boolean',
                'description' => 'Email Notifications',
            ],
            [
                'setting_key' => 'sms_notifications',
                'setting_value' => '0',
                'setting_type' => 'boolean',
                'description' => 'SMS Notifications',
            ],
            [
                'setting_key' => 'push_notifications',
                'setting_value' => '1',
                'setting_type' => 'boolean',
                'description' => 'Push Notifications',
            ],
            [
                'setting_key' => 'two_factor_auth',
                'setting_value' => '0',
                'setting_type' => 'boolean',
                'description' => 'Two-Factor Authentication',
            ],
            [
                'setting_key' => 'password_expiry',
                'setting_value' => '90',
                'setting_type' => 'integer',
                'description' => 'Password Expiry (Days)',
            ],
        ];

        // Using Query Builder
        foreach ($data as $setting) {
            // Check if setting already exists
            $existing = $this->db->table('settings')->where('setting_key', $setting['setting_key'])->get()->getRow();
            
            if (!$existing) {
                $this->db->table('settings')->insert($setting);
            }
        }
    }
}