<?php

namespace App\Database\Seeds;

use CodeIgniter\Database\Seeder;

class CompaniesSeeder extends Seeder
{
    public function run()
    {
        $data = [
            [
                'company_name'     => 'ABC Corporation',
                'company_address'  => '123 Business Park, Mumbai, Maharashtra 400001',
                'area'             => 'Kachigam',
                'company_email'    => 'info@abccorp.com',
                'hr_name'          => 'John Smith',
                'hr_number'        => '+919876543210',
                'manager_name'     => 'Jane Doe',
                'manager_number'   => '+919876543211',
                'total_workers'    => 150,
                'gst_tax_number'   => 'GSTIN1234567890',
                'status'           => 'Active',
                'notes'            => 'Leading IT company in the region',
                'created_at'       => date('Y-m-d H:i:s'),
                'updated_at'       => date('Y-m-d H:i:s'),
            ],
            [
                'company_name'     => 'XYZ Industries',
                'company_address'  => '456 Industrial Area, Surat, Gujarat 395001',
                'area'             => 'Somnath',
                'company_email'    => 'contact@xyzindustries.com',
                'hr_name'          => 'Robert Johnson',
                'hr_number'        => '+919876543220',
                'manager_name'     => 'Emily Wilson',
                'manager_number'   => '+919876543221',
                'total_workers'    => 85,
                'gst_tax_number'   => 'GSTIN0987654321',
                'status'           => 'Active',
                'notes'            => 'Manufacturing company specializing in textiles',
                'created_at'       => date('Y-m-d H:i:s'),
                'updated_at'       => date('Y-m-d H:i:s'),
            ],
            [
                'company_name'     => 'Tech Solutions Ltd',
                'company_address'  => '789 Tech Park, Bangalore, Karnataka 560001',
                'area'             => 'Bhenslore',
                'company_email'    => 'support@techsolutions.com',
                'hr_name'          => 'Michael Brown',
                'hr_number'        => '+919876543230',
                'manager_name'     => 'Sarah Davis',
                'manager_number'   => '+919876543231',
                'total_workers'    => 200,
                'gst_tax_number'   => 'GSTIN1122334455',
                'status'           => 'Inactive',
                'notes'            => 'Software development company',
                'created_at'       => date('Y-m-d H:i:s'),
                'updated_at'       => date('Y-m-d H:i:s'),
            ],
        ];

        // Using Query Builder
        $this->db->table('companies')->insertBatch($data);
    }
}