<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class FixPayrollColumnInCompaniesTable extends Migration
{
    public function up()
    {
        // Add payroll column if it doesn't exist
        try {
            $this->forge->addColumn('companies', [
                'payroll' => [
                    'type' => 'INT',
                    'constraint' => 11,
                    'null' => true,
                    'default' => null,
                ],
            ]);
        } catch (\Exception $e) {
            // Column might already exist, ignore the error
        }
    }

    public function down()
    {
        // Drop payroll column if it exists
        try {
            $this->forge->dropColumn('companies', 'payroll');
        } catch (\Exception $e) {
            // Column might not exist, ignore the error
        }
    }
}
