<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateContractorsTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'BIGINT',
                'constraint'     => 20,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'company_id' => [
                'type'       => 'BIGINT',
                'constraint' => 20,
                'unsigned'   => true,
            ],
            'registration_number' => [
                'type'       => 'VARCHAR',
                'constraint' => '100',
                'null'       => true,
            ],
            'contractor_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'contractor_address' => [
                'type'       => 'TEXT',
                'null'       => true,
            ],
            'validity_date' => [
                'type' => 'DATE',
                'null' => true,
            ],
            'number_of_employees' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 0,
            ],
            'sr_no_contractor' => [
                'type'       => 'VARCHAR',
                'constraint' => '50',
                'null'       => true,
            ],
            'nature_of_work' => [
                'type'       => 'TEXT',
                'null'       => true,
            ],
            'no_of_contract_labours' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 0,
            ],
            'less_than_20' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 0,
            ],
            'twenty_and_above' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 0,
            ],
            'remarks' => [
                'type'       => 'TEXT',
                'null'       => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        
        $this->forge->addKey('id', true);
        $this->forge->addKey('company_id');
        $this->forge->addForeignKey('company_id', 'companies', 'id', 'CASCADE', 'CASCADE');
        $this->forge->createTable('contractors');
    }

    public function down()
    {
        $this->forge->dropTable('contractors');
    }
}