<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class UpdateCompaniesTableRemoveContactFields extends Migration
{
    public function up()
    {
        // Remove the HR and Manager fields from companies table
        $this->forge->dropColumn('companies', ['hr_name', 'hr_number', 'manager_name', 'manager_number']);
    }

    public function down()
    {
        // Add back the HR and Manager fields to companies table
        $fields = [
            'hr_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'after'      => 'company_email'
            ],
            'hr_number' => [
                'type'       => 'VARCHAR',
                'constraint' => '20',
                'after'      => 'hr_name'
            ],
            'manager_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
                'after'      => 'hr_number'
            ],
            'manager_number' => [
                'type'       => 'VARCHAR',
                'constraint' => '20',
                'null'       => true,
                'after'      => 'manager_name'
            ]
        ];
        
        $this->forge->addColumn('companies', $fields);
    }
}