<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class ModifyPayrollColumnInCompaniesTable extends Migration
{
    public function up()
    {
        // Modify the payroll column to be INT instead of DECIMAL
        $this->forge->modifyColumn('companies', [
            'payroll' => [
                'type'       => 'INT',
                'constraint' => 11,
                'null'       => true,
                'default'    => null
            ]
        ]);
    }

    public function down()
    {
        // Revert the payroll column back to DECIMAL
        $this->forge->modifyColumn('companies', [
            'payroll' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
                'null'       => true
            ]
        ]);
    }
}