<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddPayrollToCompaniesTable extends Migration
{
    public function up()
    {
        // Check if payroll column exists
        try {
            // Add the payroll column to the companies table
            $this->forge->addColumn('companies', [
                'payroll' => [
                    'type'       => 'DECIMAL',
                    'constraint' => '10,2',
                    'null'       => true,
                    'after'      => 'contractual_workers'
                ]
            ]);
        } catch (\Exception $e) {
            // Column might already exist, ignore the error
        }
    }

    public function down()
    {
        // Check if payroll column exists before dropping
        try {
            // Drop the payroll column from the companies table
            $this->forge->dropColumn('companies', 'payroll');
        } catch (\Exception $e) {
            // Column might not exist, ignore the error
        }
    }
}