<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreateCompaniesTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'BIGINT',
                'constraint'     => 20,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'company_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'company_address' => [
                'type' => 'TEXT',
            ],
            'area' => [
                'type'       => 'ENUM',
                'constraint' => ['Kachigam', 'Dabhel', 'Bhimpore', 'Kadaiya', 'Ringanwada', 'Somnath', 'Bhenslore', 'Jani Vankad'],
            ],
            'company_email' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'unique'     => true,
            ],
            'hr_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
            ],
            'hr_number' => [
                'type'       => 'VARCHAR',
                'constraint' => '20',
            ],
            'manager_name' => [
                'type'       => 'VARCHAR',
                'constraint' => '255',
                'null'       => true,
            ],
            'manager_number' => [
                'type'       => 'VARCHAR',
                'constraint' => '20',
                'null'       => true,
            ],
            'total_workers' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 0,
            ],
            'contractual_workers' => [
                'type'       => 'INT',
                'constraint' => 11,
                'default'    => 0,
            ],
            'payroll' => [
                'type'       => 'DECIMAL',
                'constraint' => '10,2',
                'null'       => true,
            ],
            'gst_tax_number' => [
                'type'       => 'VARCHAR',
                'constraint' => '15',
                'null'       => true,
            ],
            'status' => [
                'type'       => 'ENUM',
                'constraint' => ['Active', 'Inactive'],
                'default'    => 'Active',
            ],
            'notes' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'deleted_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        
        $this->forge->addKey('id', true);
        $this->forge->addKey('company_name');
        $this->forge->addKey('area');
        $this->forge->addKey('status');
        $this->forge->createTable('companies');
    }

    public function down()
    {
        $this->forge->dropTable('companies');
    }
}