<?php

namespace App\Controllers;

use App\Controllers\BaseController;
use Dompdf\Dompdf;
use Dompdf\Options;

class TestPdf extends BaseController
{
    public function index()
    {
        // Test Dompdf functionality
        $html = '
        <!DOCTYPE html>
        <html>
        <head>
            <title>Test PDF</title>
            <style>
                body { font-family: Arial, sans-serif; }
                h1 { color: #333; }
                p { font-size: 14px; }
            </style>
        </head>
        <body>
            <h1>Dompdf Test</h1>
            <p>If you can see this PDF, then Dompdf is working correctly!</p>
            <p>Generated at: ' . date('Y-m-d H:i:s') . '</p>
        </body>
        </html>';

        // Generate PDF using Dompdf
        $options = new Options();
        $options->set('defaultFont', 'Arial');
        $options->set('isRemoteEnabled', true);
        
        $dompdf = new Dompdf($options);
        $dompdf->loadHtml($html);
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();
        
        // Output the PDF
        return $this->response
            ->setHeader('Content-Type', 'application/pdf')
            ->setHeader('Content-Disposition', 'inline; filename="test.pdf"')
            ->setBody($dompdf->output());
    }
}