<?php

use CodeIgniter\Router\RouteCollection;

/**
 * @var RouteCollection $routes
 */
$routes->get('/', 'Auth::login');
$routes->get('/login', 'Auth::login');
$routes->post('/login', 'Auth::attemptLogin');
$routes->get('/logout', 'Auth::logout');

// Test Error Routes
$routes->get('/test-error/404', 'TestError::notFound');
$routes->get('/test-error/general', 'TestError::general');

// Test PDF route
$routes->get('/test-pdf', 'TestPdf::index');

// Forgot Password Routes
$routes->get('/forgot-password', 'ForgotPassword::index');
$routes->post('/forgot-password/send-otp', 'ForgotPassword::sendOtp');
$routes->get('/forgot-password/verify-otp', 'ForgotPassword::verifyOtp');
$routes->post('/forgot-password/process-otp', 'ForgotPassword::processOtp');
$routes->get('/forgot-password/reset-password', 'ForgotPassword::resetPassword');
$routes->post('/forgot-password/update-password', 'ForgotPassword::updatePassword');

$routes->get('/dashboard', 'Dashboard::index', ['filter' => 'auth']);
$routes->get('/dashboard/search', 'Dashboard::search', ['filter' => 'auth']);
$routes->get('/dashboard/notifications', 'Dashboard::getNotificationsData', ['filter' => 'auth']);
$routes->get('/notifications', 'Dashboard::notifications', ['filter' => 'auth']);
$routes->post('/dashboard/notifications/mark-read', 'Dashboard::markNotificationsAsRead', ['filter' => 'auth']);
$routes->post('/dashboard/notifications/mark-read', 'Dashboard::markNotificationsAsRead', ['filter' => 'auth']);

// Settings Routes
$routes->group('settings', ['filter' => 'auth'], function ($routes) {
    $routes->get('/', 'Settings::index');
    $routes->post('update-general', 'Settings::updateGeneral');
    $routes->post('update-notifications', 'Settings::updateNotifications');
    $routes->post('update-security', 'Settings::updateSecurity');
});

// Companies Management Routes
$routes->group('companies', ['filter' => 'auth'], function ($routes) {
    $routes->get('/', 'Companies::index');
    $routes->get('create', 'Companies::create');
    $routes->post('store', 'Companies::store');
    $routes->get('edit/(:num)', 'Companies::edit/$1');
    $routes->post('update/(:num)', 'Companies::update/$1');
    $routes->get('delete/(:num)', 'Companies::delete/$1');
    $routes->post('delete/(:num)', 'Companies::delete/$1');
    $routes->get('view/(:num)', 'Companies::view/$1');
    $routes->get('export/csv', 'Companies::exportCsv');
    $routes->get('export/pdf', 'Companies::exportPdf');
    
    // Company-specific personnel routes
    $routes->get('(:num)/personnel', 'Personnel::indexByCompany/$1');
    $routes->get('(:num)/personnel/create', 'Personnel::createByCompany/$1');
    $routes->get('(:num)/personnel/export/csv', 'Personnel::exportCsvByCompany/$1');
    $routes->get('(:num)/personnel/export/pdf', 'Personnel::exportPdfByCompany/$1');
});

// Units Management Routes
$routes->group('units', ['filter' => 'auth'], function ($routes) {
    $routes->get('/', 'Units::index');
    $routes->get('create', 'Units::create');
    $routes->post('store', 'Units::store');
    $routes->get('edit/(:num)', 'Units::edit/$1');
    $routes->post('update/(:num)', 'Units::update/$1');
    $routes->get('delete/(:num)', 'Units::delete/$1');
    $routes->post('delete/(:num)', 'Units::delete/$1');
    $routes->get('view/(:num)', 'Units::view/$1');
    $routes->get('export/csv', 'Units::exportCsv');
    $routes->get('export/pdf', 'Units::exportPdf');
});

// Personnel Management Routes
$routes->group('personnel', ['filter' => 'auth'], function ($routes) {
    $routes->get('/', 'Personnel::index');
    $routes->get('create', 'Personnel::create');
    $routes->post('store', 'Personnel::store');
    $routes->get('edit/(:num)', 'Personnel::edit/$1');
    $routes->post('update/(:num)', 'Personnel::update/$1');
    $routes->get('delete/(:num)', 'Personnel::delete/$1');
    $routes->post('delete/(:num)', 'Personnel::delete/$1');
    $routes->get('view/(:num)', 'Personnel::view/$1');
    $routes->get('export/csv', 'Personnel::exportCsv');
    $routes->get('export/pdf', 'Personnel::exportPdf');
});

// Security Logs Routes (Superadmin only)
$routes->group('security-logs', ['filter' => 'auth:superadmin'], function ($routes) {
    $routes->get('/', 'SecurityLogs::index');
});

// Contractors Management Routes
$routes->group('contractors', ['filter' => 'auth'], function ($routes) {
    $routes->get('/', 'Contractors::index');
    $routes->get('create', 'Contractors::create');
    $routes->post('store', 'Contractors::store');
    $routes->get('edit/(:num)', 'Contractors::edit/$1');
    $routes->post('update/(:num)', 'Contractors::update/$1');
    $routes->get('delete/(:num)', 'Contractors::delete/$1');
    $routes->get('view/(:num)', 'Contractors::view/$1');
    $routes->get('export/csv', 'Contractors::exportCsv');
    $routes->get('export/pdf', 'Contractors::exportPdf');
    $routes->get('company-details/(:num)', 'Contractors::getCompanyDetails/$1');
    
    // Company-specific contractor routes
    $routes->get('company/(:num)', 'Contractors::indexByCompany/$1');
});

// Admin Management Routes (Superadmin only)
$routes->group('admin', ['filter' => 'auth:superadmin'], function ($routes) {
    $routes->get('/', 'Admin::index');
    $routes->get('create', 'Admin::create');
    $routes->post('store', 'Admin::store');
    $routes->get('verify-otp', 'Admin::verifyOtp');
    $routes->post('process-otp', 'Admin::processOtp');
    $routes->get('resend-otp', 'Admin::resendOtp');
    $routes->post('resend-otp', 'Admin::resendOtp');
    $routes->get('edit/(:num)', 'Admin::edit/$1');
    $routes->post('update/(:num)', 'Admin::update/$1');
    $routes->get('verify-update-otp/(:num)', 'Admin::verifyUpdateOtp/$1');
    $routes->post('process-update-otp/(:num)', 'Admin::processUpdateOtp/$1');
    $routes->post('resend-update-otp/(:num)', 'Admin::resendUpdateOtp/$1');
    $routes->get('delete/(:num)', 'Admin::delete/$1');
});