<?php

namespace Config;

use CodeIgniter\Events\Events;
use CodeIgniter\Exceptions\FrameworkException;
use CodeIgniter\HotReloader\HotReloader;

/*
 * --------------------------------------------------------------------
 * Application Events
 * --------------------------------------------------------------------
 * Events allow you to tap into the execution of the program without
 * modifying or extending core files. This file provides a central
 * location to define your events, though they can always be added
 * at run-time, also, if needed.
 *
 * You create code that can execute by subscribing to events with
 * the 'on()' method. This accepts any form of callable, including
 * Closures, that will be executed when the event is triggered.
 *
 * Example:
 *      Events::on('create', [$myInstance, 'myMethod']);
 */

Events::on('pre_system', static function () {
    if (ENVIRONMENT !== 'testing') {
        if (ini_get('zlib.output_compression')) {
            throw FrameworkException::forEnabledZlibOutputCompression();
        }

        while (ob_get_level() > 0) {
            ob_end_flush();
        }

        ob_start(static fn ($buffer) => $buffer);
    }

    /*
     * --------------------------------------------------------------------
     * Debug Toolbar Listeners.
     * --------------------------------------------------------------------
     * If you delete, they will no longer be collected.
     */
    if (CI_DEBUG && ! is_cli()) {
        Events::on('DBQuery', 'CodeIgniter\Debug\Toolbar\Collectors\Database::collect');
        // Services::toolbar()->respond(); // Disabled to prevent debugbar connection issues
        // Hot Reloader route - for framework use on the hot reloader.
        if (ENVIRONMENT === 'development') {
            Services::routes()->get('__hot-reload', static function () {
                (new HotReloader())->run();
            });
        }
    }
});

// Add security headers
Events::on('pre_system', function() {
    $response = service('response');
    
    // Security headers
    $response->setHeader('X-Content-Type-Options', 'nosniff');
    $response->setHeader('X-Frame-Options', 'SAMEORIGIN');
    $response->setHeader('X-XSS-Protection', '1; mode=block');
    $response->setHeader('Strict-Transport-Security', 'max-age=31536000; includeSubDomains; preload');
    $response->setHeader('Referrer-Policy', 'strict-origin-when-cross-origin');
    $response->setHeader('Permissions-Policy', 'geolocation=(), microphone=(), camera=(), usb=(), payment=()');
    $response->setHeader('Expect-CT', 'max-age=86400, enforce');
    $response->setHeader('X-Permitted-Cross-Domain-Policies', 'none');
    $response->setHeader('Cache-Control', 'no-cache, no-store, must-revalidate');
    $response->setHeader('Pragma', 'no-cache');
    $response->setHeader('Expires', '0');
});