<?php

namespace Config;

use CodeIgniter\Config\BaseConfig;

class Email extends BaseConfig
{
    public string $fromEmail  = '';
    public string $fromName   = '';
    public string $recipients = '';

    /**
     * The "user agent"
     */
    public string $userAgent = 'CodeIgniter';

    /**
     * The mail sending protocol: mail, sendmail, smtp
     */
    public string $protocol = 'smtp';

    /**
     * The server path to Sendmail.
     */
    public string $mailPath = '/usr/sbin/sendmail';

    /**
     * SMTP Server Hostname
     */
    public string $SMTPHost = '';

    /**
     * SMTP Username
     */
    public string $SMTPUser = '';

    /**
     * SMTP Password
     */
    public string $SMTPPass = '';

    /**
     * SMTP Port
     */
    public int $SMTPPort = 587;

    /**
     * SMTP Timeout (in seconds)
     */
    public int $SMTPTimeout = 60;

    /**
     * Enable persistent SMTP connections
     */
    public bool $SMTPKeepAlive = true;

    /**
     * SMTP Encryption.
     *
     * @var string '', 'tls' or 'ssl'. 'tls' will issue a STARTTLS command
     *             to the server. 'ssl' means implicit SSL. Connection on port
     *             465 should set this to ''.
     */
    public string $SMTPCrypto = 'tls';

    /**
     * Enable word-wrap
     */
    public bool $wordWrap = true;

    /**
     * Character count to wrap at
     */
    public int $wrapChars = 76;

    /**
     * Type of mail, either 'text' or 'html'
     */
    public string $mailType = 'html';

    /**
     * Character set (utf-8, iso-8859-1, etc.)
     */
    public string $charset = 'UTF-8';

    /**
     * Whether to validate the email address
     */
    public bool $validate = true;

    /**
     * Email Priority. 1 = highest. 5 = lowest. 3 = normal
     */
    public int $priority = 3;

    /**
     * Newline character. (Use “\r\n” to comply with RFC 822)
     */
    public string $CRLF = "\r\n";

    /**
     * Newline character. (Use “\r\n” to comply with RFC 822)
     */
    public string $newline = "\r\n";

    /**
     * Enable BCC Batch Mode.
     */
    public bool $BCCBatchMode = false;

    /**
     * Number of emails in each BCC batch
     */
    public int $BCCBatchSize = 200;

    /**
     * Enable notify message from server
     */
    public bool $DSN = false;

    /**
     * Initialize email configuration from environment variables
     */
    public function __construct()
    {
        parent::__construct();

        // Load from environment variables if set
        $this->fromEmail = $_ENV['email.fromEmail'] ?? '';
        $this->fromName = $_ENV['email.fromName'] ?? '';
        $this->SMTPHost = $_ENV['email.SMTPHost'] ?? '';
        $this->SMTPPort = (int)($_ENV['email.SMTPPort'] ?? 587);
        $this->SMTPUser = $_ENV['email.SMTPUser'] ?? '';
        $this->SMTPPass = $_ENV['email.SMTPPass'] ?? '';
        $this->SMTPCrypto = $_ENV['email.SMTPCrypto'] ?? 'tls';
        $this->mailType = $_ENV['email.mailType'] ?? 'html';
        $this->charset = $_ENV['email.charset'] ?? 'UTF-8';
        $this->SMTPTimeout = (int)($_ENV['email.SMTPTimeout'] ?? 60);
        $this->SMTPKeepAlive = filter_var($_ENV['email.keepAlive'] ?? false, FILTER_VALIDATE_BOOLEAN);
    }
}