# Secure Login System - CodeIgniter 4

A secure login system built with CodeIgniter 4 that includes user authentication, role-based access control, and modern UI design with dark/light mode toggle.

## Features

- User authentication with secure password hashing
- Role-based access control (admin, superadmin)
- CSRF protection
- Session management with secure practices
- Modern UI with TailwindCSS
- Responsive design for all devices
- Dark/Light mode toggle with system preference detection
- Theme preference saved in localStorage
- Enhanced login page with gradient design
- Dashboard with user information display
- Forgot password system with email OTP verification
- Companies Management Module with full CRUD functionality

## Requirements

- PHP 7.4 or higher
- MySQL 5.7 or higher
- Composer

## Installation

1. Clone or download the project
2. Run `composer install` to install dependencies
3. Create a MySQL database
4. Update the `.env` file with your database credentials
5. Run migrations: `php spark migrate`
6. Seed the database: `php spark db:seed UserSeeder`
7. Start the development server: `php spark serve`

## Default Users

- **Admin**: 
  - Username: `admin`
  - Email: `admin@example.com`
  - Password: `Admin@123`
  
- **Super Admin**: 
  - Username: `superadmin`
  - Email: `superadmin@example.com`
  - Password: `Super@123`

## Routes

- `/login` - Login page
- `/logout` - Logout endpoint
- `/forgot-password` - Forgot password page
- `/forgot-password/send-otp` - Send OTP endpoint
- `/forgot-password/verify-otp` - Verify OTP page
- `/forgot-password/process-otp` - Process OTP endpoint
- `/forgot-password/reset-password` - Reset password page
- `/forgot-password/update-password` - Update password endpoint
- `/dashboard` - Protected dashboard page
- `/companies` - Companies management module
- `/companies/create` - Add new company
- `/companies/edit/{id}` - Edit company
- `/companies/view/{id}` - View company details
- `/companies/delete/{id}` - Delete company (soft delete)
- `/companies/export/csv` - Export companies as CSV
- `/companies/export/pdf` - Export companies as PDF

## Security Features

- Passwords hashed with `password_hash()` using `PASSWORD_DEFAULT`
- CSRF protection enabled
- Session ID regeneration on login
- Input validation and sanitization
- Auth filter to protect routes
- OTP verification for password reset

## Design Features

- Modern gradient design with blue color scheme (#5EC9F8 → #3A82D4 → #214D8C)
- Responsive layout for all screen sizes
- Dark/Light mode toggle with system preference detection
- Persistent theme preference saved in localStorage
- Enhanced login form with icons and improved UX
- Dashboard with user profile display
- Forgot password flow with OTP verification
- Branding with JTECH logos

## Companies Management Module

The system includes a full-featured Companies Management module with:

- Add, Edit, View, and Delete operations
- Form validation for all fields
- Search and filter capabilities
- Export to CSV and PDF
- Responsive design for all devices
- Role-based access control

See `README_COMPANIES_MODULE.md` for detailed documentation.

## Forgot Password Flow

1. User clicks "Forgot your password?" on login page
2. User enters their email address
3. System generates a 6-digit OTP and sends it to the user's email
4. User enters the OTP on the verification page
5. If OTP is valid, user can reset their password
6. After password reset, user is redirected to login page

## Dark/Light Mode

The application automatically detects your system preference for dark or light mode and applies the appropriate theme. You can also manually toggle between themes using the button in the top-right corner. Your preference is saved in localStorage and will persist across sessions.

## Directory Structure

```
app/
├── Controllers/
│   ├── Auth.php
│   ├── Companies.php
│   ├── Dashboard.php
│   └── ForgotPassword.php
├── Models/
│   ├── CompanyModel.php
│   └── UserModel.php
├── Views/
│   ├── companies/
│   │   ├── create.php
│   │   ├── edit.php
│   │   ├── list.php
│   │   └── view.php
│   ├── login.php
│   ├── dashboard.php
│   ├── forgot_password.php
│   ├── verify_otp.php
│   └── reset_password.php
├── Filters/
│   └── AuthFilter.php
├── Database/
│   ├── Migrations/
│   │   ├── 2025-09-24-000000_CreateUsersTable.php
│   │   └── 2025-09-25-000000_CreateCompaniesTable.php
│   └── Seeds/
│       ├── CompaniesSeeder.php
│       └── UserSeeder.php
```

## Technologies Used

- CodeIgniter 4
- MySQL
- TailwindCSS (CDN)
- PHP 8+

## License

This project is open source and available under the MIT License.